#include <sys/types.h>
#include <unistd.h>
#include <io.h>

ssize_t pwrite( int fd, const void *buf, size_t nbyte, off_t offset )
{
    off_t current;
    ssize_t nwritten;
    int oerrno;

    current = lseek( fd, 0, SEEK_CUR );
    if( current == ( off_t )-1 || lseek( fd, offset, SEEK_SET ) == ( off_t )-1 )
        return( -1 );

    nwritten = write( fd, buf, nbyte );
    
    /* 
     * Ignore errors in restoring the file position; this isn't ideal, but
     * reporting a failed write when the write succeeded is worse.  Make
     * sure that errno, if set, is set by write and not lseek.
     */
    oerrno = errno;
    lseek( fd, current, SEEK_SET );
    errno = oerrno;
    
    return( nwritten );
}

