#include <time.h>
#include "internal.h"

time_t mktime( struct tm *timeptr )
{
    time_t tt;

    if( ( timeptr->tm_year < 70 ) || ( timeptr->tm_year > 120 ) ) {
        tt = ( time_t ) - 1;
    } else {
        tt = __ymd_to_scalar( timeptr->tm_year + 1900,
                              timeptr->tm_mon + 1,
                              timeptr->tm_mday ) -
             __ymd_to_scalar(1970, 1, 1);
        tt = tt * 24 + timeptr->tm_hour;
        tt = tt * 60 + timeptr->tm_min;
        tt = tt * 60 + timeptr->tm_sec;
    }

    return( tt );
}

