#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

int main( int argc, char **argv )
{
    int failure = 0, handle;
    FILE *fp = fopen( "TEST.TXT", "w+b" );
    fpos_t position = 0;
    char freadbuf[ 17 ], *s, *p, tempfilename[ PATH_MAX ];

    if( fp == NULL || ( fp->fd & O_TEXT ) ) {
        printf( "fopen() - Failure\n" );
        failure++;
    } else printf( "fopen() - Success\n" );

    if( fwrite( "Hello, world.\n", 14, 1, fp ) != 1 ) {
        printf( "fwrite() - Failure\n" );
        failure++;
    } else printf( "fwrite() - Success\n" );
    
    if( ftello( fp ) != 14L ) {
        printf( "ftello() - Failure\n" );
        failure++;
    } else printf( "ftello() - Success\n" );

    if( fsetpos( fp, &position ) != 0 ) {
        printf( "fsetpos() - Failure\n" );
        failure++;
    } else printf( "fsetpos() - Success\n" );

    if( ftell( fp ) != 0L ) {
        printf( "ftell() - Failure\n" );
        failure++;
    } else printf( "ftell() - Success\n" );

    if( fread( freadbuf, 14, 1, fp ) != 1 ||
        memcmp( freadbuf, "Hello, world.\n", 14 ) != 0 ) {
        printf( "fread() - Failure\n" );
        failure++;
    } else printf( "fread() - Success\n" );

    if( fseek( fp, 0L, SEEK_SET ) != 0 ) {
        printf( "fseek() - Failure\n" );
        failure++;
    } else printf( "fseek() - Success\n" );

    if( strcmp( fgets( freadbuf, 15, fp ), "Hello, world.\n" ) != 0 ) {
        printf( "fgets() - Failure\n" );
        failure++;
    } else printf( "fgets() - Success\n" );

    if( fclose( fp ) != 0 ) {
        printf( "fclose() - Failure\n" );
        failure++;
    } else printf( "fclose() - Success\n" );

    handle = open( "TEST.TXT", O_RDWR | O_BINARY );

    if( ( fp = fdopen( handle, "rb+" ) ) == NULL ) {
        printf( "fdopen() - Failure\n" );
        failure++;
    } else printf( "fdopen() - Success\n" );

    if( strcmp( fgets( freadbuf, 15, fp ), "Hello, world.\n" ) != 0 ) {
        printf( "fgets() (2) - Failure\n" );
        failure++;
    } else printf( "fgets() (2) - Success\n" );

    if( fileno( fp ) != handle ) {
        printf( "fileno() - Failure\n" );
        failure++;
    } else printf( "fileno() - Success\n" );

    if( fseeko( fp, 0L, SEEK_SET ) != 0 ) {
        printf( "fseeko() - Failure\n" );
        failure++;
    } else printf( "fseeko() - Success\n" );

    if( fputs( "Hello, world.\r\n", fp ) < 0 ) {
        printf( "fputs() - Failure\n" );
        failure++;
    } else printf( "fputs() - Success\n" );

    rewind( fp );

    if( ftell( fp ) != 0L ) {
        printf( "rewind() - Failure\n" );
        failure++;
    } else printf( "rewind() - Success\n" );

    if( strcmp( fgets( freadbuf, 16, fp ), "Hello, world.\r\n" ) != 0 ) {
        printf( "fgets() (3) - Failure\n" );
        failure++;
    } else printf( "fgets() (3) - Success\n" );

    freopen( "TEST.TXT", "rt+", fp );

    if( strcmp( fgets( freadbuf, 16, fp ), "Hello, world.\n" ) != 0 ) {
        printf( "fgets() (4), freopen() - Failure\n" );
        failure++;
    } else printf( "fgets() (4), freopen() - Success\n" );

    if( printf( "printf() - Success" ) != 18 ) {
        printf( "\rprintf() - Failure\n" );
        failure++;
    } else printf( "\n" );

    fclose( fp );

    unlink( "TEST.TXT" );

    p = malloc( PATH_MAX + 4 );
    strcpy( p, "TMP=" );
    getcwd( p + 4, PATH_MAX );

    putenv( p );

    s = tempnam( P_tmpdir, "tmp" );

    p += 4;

    strcat( p, "\\tmp" );

    if( strncmp( s, p, strlen( p ) ) != 0 ) {
        printf( "tempnam() - Failure\n" );
        failure++;
    } else printf( "tempnam() - Success\n" );

    free( s );

    putenv( "TMP=" );

    if( ( fp = tmpfile() ) == NULL ||
        access( strcpy( tempfilename, fp->tempfnam ), F_OK ) != 0 ) {
        printf( "tmpfile() - Failure\n" );
        failure++;
    } else printf( "tmpfile() - Success\n" );

    printf( "%s\n", fp->tempfnam );

    fclose( fp );

    if( access( tempfilename, F_OK ) == 0 ) {
        printf( "fclose() (2) - Failure\n" );
        failure++;
    } else printf( "fclose() (2) - Success\n" );

    return( failure );
}

