#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/stat.h>

int main( int argc, char **argv )
{
    int failure = 0, handle = creat( "TEST.TXT", S_IREAD|S_IWRITE );
    char readbuf[ 15 ];

    printf( "Io.lib\n" );

    if( access( argv[ 0 ], E_OK ) != 0 ) {
        printf( "access() - Failure\n" );
        failure++;
    } else printf( "access() - Success\n" );

    if( handle == -1 ) {
        printf( "creat() - Failure\n" );
        failure++;
    } else printf( "creat() - Success\n" );


    if( close( handle ) == -1 ) {
        printf( "close() - Failure\n" );
        failure++;
    } else printf( "close() - Success\n" );

    if( _chmod( "TEST.TXT", 0 ) & _A_RDONLY ) {
        printf( "creat() (2) - Failure\n" );
        failure++;
    } else printf( "creat() (2) - Success\n" );

    if( chmod( "TEST.TXT", S_IREAD ) == -1 ||
        !( _chmod( "TEST.TXT", 0 ) & _A_RDONLY ) ) {
        printf( "chmod() - Failure\n" );
        failure++;
    } else printf( "chmod() - Success\n" );

    if( chmod( "TEST.TXT", S_IREAD|S_IWRITE ) == -1 ||
        ( _chmod( "TEST.TXT", 0 ) & _A_RDONLY ) ) {
        printf( "chmod() (2) - Failure\n" );
        failure++;
    } else printf( "chmod() (2) - Success\n" ); 

    if( ( handle = _creat( "TEST.TXT", _A_NORMAL ) ) == -1 ) {
        printf( "_creat() - Failure\n" );
        failure++;
    } else printf( "_creat() - Success\n" );

    if( creatnew( "TEST.TXT", _A_NORMAL ) != -1 ) {
        printf( "creatnew() - Failure\n" );
        failure++;
    } else printf( "creatnew() - Success\n" );

    if( chsize( handle, 4096L ) == -1 || filelength( handle ) != 4096L ) {
        printf( "chsize(), filelength() - Failure\n" );
        failure++;
    } else printf( "chsize(), filelength() - Success\n" );

    if( lseek( handle, 4096L, SEEK_SET ) == -1 ) {
        printf( "lseek() = Failure\n" );
        failure++;
    } else printf( "lseek() - Success\n" );

    if( !eof( handle ) ) {
        printf( "eof() - Failure\n" );
        failure++;
    } else printf( "eof() - Success\n" );

    if( !isatty( 2 ) ) {
        printf( "isatty() - Failure\n" );
        failure++;
    } else printf( "isatty() - Success\n" );

    if( _close( handle ) == -1 ) {
        printf( "_close() - Failure\n" );
        failure++;
    } else printf( "_close() - Success\n" );

    if( ( handle = open( "TEST.TXT", O_RDWR ) ) == -1 ) {
        printf( "open() - Failure\n" );
        failure++;
    } else printf( "open() - Success\n" );

    if( write( handle, "Hello, world.\n", 14 ) == -1 ) {
        printf( "write() - Failure\n" );
        failure++;
    } else printf( "write() - Success\n" );

    lseek( handle, 0L, SEEK_SET );

    if( read( handle, readbuf, 14 ) == -1 ||
        memcmp( readbuf, "Hello, world.\n", 14 ) != 0 ) {
        printf( "read() - Failure\n" );
        failure++;
    } else printf( "read() - Success\n" );

    _close( handle );

    if( ( handle = _open( "TEST.TXT", O_RDONLY ) ) == -1 ) {
        printf( "_open() - Failure\n" );
        failure++;
    } else printf( "_open() - Success\n" );

    if( _read( handle, readbuf, 14 ) == -1 ||
        memcmp( readbuf, "Hello, world.\n", 13 ) != 0 ) {
        printf( "_read() - Failure\n" );
        failure++;
    } else printf( "_read() - Success\n" );

    if( tell( handle ) != 14L ) {
        printf( "tell() - Failure\n" );
        failure++;
    } else printf( "tell() - Success\n" );

    _close( handle );

    if( rename( "TEST.TXT", "TEST.REN" ) == -1 ||
        access( "TEST.REN", F_OK ) != 0 ) {
        printf( "rename() - Failure\n" );
        failure++;
    } else printf( "rename() - Success\n" );

    if( remove( "TEST.REN" ) == -1 ) {
        printf( "remove() - Failure\n" );
        failure++;
    } else printf( "remove() - Success\n" );

    return( failure );
}

