#include <direct.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

int main( int argc, char **argv )
{
    DIR *dirp = opendir( "." );
    char mergetest[ PATH_MAX ], merge1[ PATH_MAX ], *cwd;
    int failure = 0;

    printf( "Direct.lib\n" );

    if( dirp == NULL ) {
        printf( "1 - Failure\n" );
        failure++;
    } else printf( "1 - Success\n" );

    if( readdir( dirp ) == NULL ) {
        printf( "2 - Failure\n" );
        failure++;
    } else printf( "2 - Success\n" );

    if( telldir( dirp ) < 1L ) {
        printf( "3 - Failure\n" );
        failure++;
    } else printf( "3 - Success\n" );

    rewinddir( dirp );

    if( telldir( dirp ) != 0L ) {
        printf( "4 - Failure\n" );
        failure++;
    } else printf( "4 - Success\n" );

    seekdir( dirp, 1L );

    if( telldir( dirp ) != 1L ) {
        printf( "5 - Failure\n" );
        failure++;
    } else printf( "5 - Success\n" );

    if( closedir( dirp ) == -1 ) {
        printf( "6 - Failure\n" );
        failure++;
    } else printf( "6 - Success\n" );

    if( mkdir( "TEST", 0 ) == -1 ) {
        printf( "7 - Failure\n" );
        failure++;
    } else printf( "7 - Success\n" );

    if( chdir( "TEST" ) == -1 ) {
        printf( "8 - Failure\n" );
        failure++;
    } else printf( "8 - Success\n" );

    if( chdir( ".." ) == -1 ) {
        printf( "9 - Failure\n" );
        failure++;
    } else printf( "9 - Success\n" );

    if( rmdir( "TEST" ) == -1 ) {
        printf( "10 - Failure\n" );
        failure++;
    } else printf( "10 - Success\n" );

    if( _chdrive( _getdrive() ) == -1 ) {
        printf( "11 - Failure\n" );
        failure++;
    } else printf( "11 - Success\n" );

    fnsplit( "C:\\HELLO\\WORLD\\TEST.C", NULL, mergetest, NULL, NULL );

    if( strcmp( mergetest, "\\HELLO\\WORLD\\" ) != 0 ) {
        printf( "12 - Failure\n" );
        failure++;
    } else printf( "12 - Success\n" );

    fnmerge( merge1, "C", "\\HELLO\\WORLD\\", "TEST", "C" );

    if( strcmp( merge1, "C:\\HELLO\\WORLD\\TEST.C" ) != 0 ) {
        printf( "13 - Failure\n" );
        failure++;
    } else printf( "13 - Success\n" );

    if( ( cwd = getcwd( NULL, 0 ) ) == NULL ) {
        printf( "14 - Failure\n" );
        failure++;
    } else printf( "14 - Success\n" );

    if( cwd != NULL ) free( cwd );

    strcpy( merge1, "XXXXXX" );

    mktemp( merge1 );

    if( strcmp( merge1, "XXXXXX" ) == 0 ) {
        printf( "15 - Failure\n" );
        failure++;
    } else printf( "15 - Success\n" );

    if( searchpath( "FIND.COM" ) == NULL ) {
        printf( "16 - Failure\n" );
        failure++;
    } else printf( "16 - Success\n" );

    return( failure );
}

