#include <string.h>
#include <sys/types.h>

size_t strlcat( char *dst, const char *src, size_t size )
{
    size_t used, length, copy;

    used = strlen( dst );
    length = strlen( src );
    
    if( size > 0 && used < size - 1 ) {
        copy = ( length >= size - used ) ? size - used - 1 : length;
        memcpy( dst + used, src, copy );
        dst[ used + copy ] = '\0';
    }
    
    return( used + length );
}

