#include <string.h>

void *memmove( void *dest, const void *source, size_t length)
{
    char *d = dest;
    const char *s = source;

    if( s < d ) {
        /* Moving from low mem to hi mem; start at end.  */
        for( s += length, d += length; length; --length)
            *d-- = *s--;
    } else if( s != d ) {
        /* Moving from hi mem to low mem; start at beginning.  */
        for( ; length; length-- )
            *d++ = *s++;
    }
    
    return( dest );
}
