#include <stdlib.h>
#include <string.h>
#include <malloc.h>

int putenv( char *entry )
{
    unsigned length, size;
    char     *temp, **p, **new_environ;

    /*  Find the length of the "NAME="  */

    temp = strchr( entry,'=' );
    if( temp == 0 ) return( -1 );

    length = ( unsigned )( temp - entry + 1 );

    /*  Scan through the environment looking for "NAME="  */

    for( p = environ; *p != 0 ; p++ ) if( strncmp( entry, *p, length ) == 0 ) {
        *p = entry;
        return( 0 );
    }

    /*  The name was not found, build a bigger environment  */

    size = p - environ;

    new_environ = ( char ** )malloc( ( size + 2 ) * sizeof( char * ) );

    if( new_environ == ( char ** ) NULL ) return( -1 );

    memcpy( ( char * )new_environ, ( char * )environ, size * sizeof( char * ) );

    new_environ[ size ]     = entry;
    new_environ[ size + 1 ] = NULL;

    environ = new_environ;

    return( 0 );
}

