#include <stdio.h>
#include <_printf.h>
#include <stdarg.h>
#include <string.h>

static char *__prntnstrng;
static int __maxlen;

int __putsnchar( int ch )
{
    char *p = __prntnstrng;

    while( *p ) p++;

    if( strlen( __prntnstrng ) >= __maxlen ) return( EOF );
    *p = ch;
    p++;
    *p = '\0';

    return( ch );
}

int vsnprintf( char *string, int maxlen, const char *fmt, va_list args )
{
    __prntnstrng = string;
    *__prntnstrng = '\0';
    __maxlen = maxlen;

    return( __vfnprintf( __putsnchar, fmt, args ) );
}

int snprintf( char *string, int maxlen, const char *fmt, ... )
{
    va_list args;

    va_start( args, fmt );
    return( vsnprintf( string, maxlen, fmt, args ) );
}
