#include <stdio.h>
#include <_printf.h>
#include <stdarg.h>
#include <string.h>
#include <malloc.h>

static char *__prntstrng;

int __putschar( int ch )
{
    char *p = __prntstrng;

    while( *p ) p++;

    if( realloc( __prntstrng, strlen( __prntstrng ) + 1 ) == NULL )
        return( EOF );
    *p = ch;
    p++;
    *p = '\0';

    return( ch );
}

int vasprintf( char **string, const char *fmt, va_list args )
{
    __prntstrng = *string;

    __prntstrng = malloc( 2 ); /* Start out with 2 bytes, alloc as we go */
    if( __prntstrng == NULL ) return( EOF );
    *__prntstrng = '\0';

    return( __vfnprintf( __putschar, fmt, args ) );
}

int asprintf( char **string, const char *fmt, ... )
{
    va_list args;

    va_start( args, fmt );
    return( vasprintf( string, fmt, args ) );
}
