#include <string.h>
#include <dir.h>
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <io.h>

char *tmpnam( char *s )
{
    char *filename, *p;
    char dirused[ _MAX_DIR ];
    static char staticname[ PATH_MAX ];
    int i = 0;

    if( s ) filename = s;
    else filename = staticname;

    p = getenv( "TMP" );
    if( access( p, D_OK ) == 0 )
        strcpy( dirused, p );
    else if( access( ( p = getenv( "TEMP" ) ), D_OK ) == 0 )
        strcpy( dirused, p );
    else if( access( ( p = getenv( "TMPDIR" ) ), D_OK ) == 0 )
        strcpy( dirused, p );
    else strcpy( dirused, P_tmpdir );

    do {
        int len = strlen( dirused );

        strcpy( filename, dirused );
        if( dirused[ len - 1 ] != '\\' ) strcat( filename, "\\" );
        strcat( filename, "tmp" );
        strcat( filename, mktemp( "XXXXXX" ) );
        i++;
    } while( access( filename, 0 ) == 0 && i <= TMP_MAX );

    if( i > TMP_MAX ) {
        return( NULL );
    }

    return( filename );
}

