#include <string.h>
#include <dir.h>
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <io.h>

char *tempnam( char *dir, char *prefix )
{
    char *filename = malloc( PATH_MAX ), *p;
    char dirused[ _MAX_DIR ];
    int i = 0;

    p = getenv( "TMP" );
    if( access( p, D_OK ) == 0 )
        strcpy( dirused, p );
    else if( access( ( p = getenv( "TEMP" ) ), D_OK ) == 0 )
        strcpy( dirused, p );
    else if( access( ( p = getenv( "TMPDIR" ) ), D_OK ) == 0 )
        strcpy( dirused, p );
    else if( access( dir, 0 ) == 0 ) strcpy( dirused, dir );
    else strcpy( dirused, P_tmpdir );

    do {
        int len = strlen( dirused );

        strcpy( filename, dirused );
        if( dirused[ len - 1 ] != '\\' ) strcat( filename, "\\" );
        strcat( filename, prefix );
        strcat( filename, mktemp( "XXXXXX" ) );
        i++;
    } while( access( filename, 0 ) == 0 && i <= TMP_MAX );

    if( i > TMP_MAX ) {
        free( filename );
        return( NULL );
    }

    return( filename );
}

