#include <stdio.h>
#include <malloc.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <io.h>

extern FILE *__openstreams[];

FILE *_fsopen( const char *filename, const char *mode, int shflag )
{
    int tmpmode = __getomode( mode ), i;
    FILE *retval = malloc( sizeof( FILE ) );

    if( retval == NULL ) return( NULL );

    if( tmpmode & O_BINARY ) retval->flags &= ~__FTEXT;
    else retval->flags |= __FTEXT;

    if( ( retval->fd = open( filename, tmpmode | shflag, S_IWRITE ) ) == -1 ) {
        free( retval );

        return( NULL );
    }

    for( i = 0; __openstreams[ i ]; i++ );
    if( i > HANDLE_MAX ) {
        close( retval->fd );
        free( retval );

        return( NULL );
    }
    __openstreams[ i ] = retval;

    retval->tempfnam = NULL;
    retval->flags = retval->unget = 0;

    return( retval );
}
