#include <stdio.h>
#include <io.h>
#include <stddef.h>

size_t fread( void * restrict ptr, size_t ilen, size_t items,
              FILE * restrict fp )
{
    int retval, bytes_to_read = ilen * items;
    char *p = ptr;

    if( fp->unget ) {
        *p = fp->unget;
        fp->unget = 0;
        p++;
        bytes_to_read--;
    }
    
    retval = read( fp->fd, p, bytes_to_read );

    if( retval == -1 || retval == 0 ) fp->flags |= __FEOF;

    return( ( retval / ilen ) );
}

