#include <sys/stat.h>
#include <dos.h>
#include <io.h>
#include <dir.h>
#include <time.h>
#include <unistd.h>
#include <libgen.h>
#include <ctype.h>

struct __stat_t {
#ifdef __CLIB_LFN__
    unsigned long ctime;     /* time of file creation      */
    unsigned long atime;     /* time of last file access   */
    char reserved[ 13 ];     /* reserved for use by DOS    */
#else
    char reserved[ 21 ];     /* reserved for use by DOS    */
#endif
    char attrib;             /* attribute byte for file    */
    unsigned long mtime;     /* time of last write to file */
    unsigned long  size;     /* length of file in bytes    */
#ifdef __CLIB_LFN__
    char name[ 260 ];        /* null-terminated filename   */
    unsigned short lfnhandle;/* DOS LFN support handle     */
#else
    char name[ 13 ];         /* null-terminated filename   */
#endif
};

int stat( const char * restrict path, struct stat * restrict buf )
{
    struct __stat_t findbuf;
    char testlink[ PATH_MAX ];
    int islink = 0;

    if( readlink( path, testlink, PATH_MAX ) != -1 ) {
        islink = 1;
    } else if( errno == ELOOP ) return( -1 );

    if( findfirst( islink ? testlink : path,
                   &findbuf,
                   _A_HIDDEN | _A_SYSTEM | _A_RDONLY | _A_SUBDIR ) )
        return( -1 );
    findclose( &findbuf );

    buf->st_attr = findbuf.attrib;
    buf->st_mode = ( ( buf->st_attr & _A_RDONLY ) ? 0 : S_IWRITE ) |
                   S_IREAD | S_IEXEC;
#ifdef __CLIB_LFN__
    buf->st_ctime = findbuf.ctime;
    buf->st_atime = findbuf.atime;
#endif
    buf->st_mtime = findbuf.mtime;
    buf->st_size = buf->st_blocks = findbuf.size;
    buf->st_uid = buf->st_gid = 1;
    buf->st_ino = ( ino_t )( buf->st_mtime + buf->st_size );
    buf->st_dev = buf->st_rdev = 
        toupper( __retsfn( islink ? testlink : path )[ 0 ] ) - 'A';
    buf->st_nlink = 1;
    buf->st_blksize = 1;

    return( 0 );
}

