#include <sys/statvfs.h>
#include <sys/stat.h>
#include <dos.h>
#include <dir.h>
#include <unistd.h>
#include <errno.h>
#include <limits.h>
#include <stdlib.h>

struct __serialnum {
    unsigned inflev;
    unsigned long sernum;
    char label[ 11 ];
    char fstype[ 8 ];
};

void __getsern( unsigned char drive, struct __serialnum *buf );
#pragma aux __getsern = \
    "mov ax, 0x6900"    \
    "mov bh, 0"         \
    "int 0x21"          \
    parm [bl] [dx]      \
    modify [ax bx dx];

int fstatvfs( int fildes, struct statvfs * restrict buf )
{
    unsigned char drive = 'Z' - 'A' + 1;
    struct stat statinf;
    struct diskfree_t spaceinf;
    struct __serialnum serinf;

    if( fstat( fildes, &statinf ) == -1 ) return( -1 );

    do {
        __getsern( drive, &serinf );
        if( serinf.sernum == statinf.st_dev ) break; /* Matching serial nums */
        drive--;
        if( drive == 0 ) return( -1 );
    } while( 1 );

    if( _dos_getdiskfree( drive, &spaceinf ) != 0 ) {
        errno = EACCES;
        return( -1 );
    }

    __getsern( drive, &serinf );

    buf->f_bsize = spaceinf.bytes_per_sector * spaceinf.sectors_per_cluster;
    buf->f_frsize = buf->f_bsize;
    buf->f_blocks = spaceinf.total_clusters;
    buf->f_bfree = spaceinf.avail_clusters;
    buf->f_bavail = buf->f_bfree;
    buf->f_files = spaceinf.total_clusters;
    buf->f_ffree = spaceinf.avail_clusters;
    buf->f_favail = buf->f_ffree;
    buf->f_fsid = serinf.sernum;
    buf->f_flag = ST_NOSUID;
    buf->f_namemax = PATH_MAX;

    return( 0 );
}

