/*
 * Tree search generalized from Knuth (6.2.2) Algorithm T just like
 * the AT&T man page says.
 *
 * The node_t structure is for internal use only, lint doesn't grok it.
 *
 * Written by reading the System V Interface Definition, not the code.
 *
 * Totally public domain.
 */

#include <search.h>
#include <stdlib.h>

/* Walk the nodes of a tree
 *
 * Parameters:
 *	root:	Root of the tree to be walked
 */
static void trecurse( const __node_t *root,
                      void ( *action )( const void *m, VISIT x, int y ),
	                  int level )
{
    if( root->llink == NULL && root->rlink == NULL )
        ( *action )( root, leaf, level );
    else {
        ( *action )( root, preorder, level );
        if( root->llink != NULL )
            trecurse( root->llink, action, level + 1 );
        ( *action )( root, postorder, level );
        if( root->rlink != NULL )
            trecurse( root->rlink, action, level + 1 );
        ( *action )( root, endorder, level );
    }
}

/* Walk the nodes of a tree
 *
 * Parameters:
 *	vroot:	Root of the tree to be walked
 */
void twalk( const void *vroot,
            void ( *action )( const void *m, VISIT x, int y ) )
{
	if( vroot != NULL && action != NULL ) trecurse( vroot, action, 0 );
}

