#include <stdlib.h>
#include <dos.h>
#include <errno.h>
#include <process.h>
#include <string.h>
#include <dir.h>
#include <io.h>
#include <limits.h>

static const char __exe[] = ".EXE";
static const char __com[] = ".COM";
static const char __bat[] = ".BAT";
static char __batflag = 0;
extern int __errorlevel;

static char *__getcomexe( const char *path )
{
    char *p;
    char fullpath[ PATH_MAX ];

    strcpy( fullpath, path );

    if( ( p = strrchr( fullpath, '\\' ) ) == NULL ) p = fullpath;

    while( *p && *p != '.' ) p++;

    if( *p == '.' ) {
        if( strcmp( p, __exe ) != 0 &&
            strcmp( p, __com ) != 0 &&
            strcmp( p, __bat ) != 0 ) while( *p ) p++;
        else {
            return( ( char * )__retsfn( fullpath ) );
        }
    }

    strcpy( p, __com );
    if( access( fullpath, E_OK ) == 0 )
        return( ( char * )__retsfn( fullpath ) );
    strcpy( p, __exe );
    if( access( fullpath, E_OK ) == 0 )
        return( ( char * )__retsfn( fullpath ) );
    strcpy( p, __bat );
    __batflag = 1;
    if( access( fullpath, E_OK ) == 0 )
        return( ( char * )__retsfn( fullpath ) );

    return( NULL );
}

int spawnve( int mode, const char *path, char **argv, char **envp )
{
    char *fullpath = __getcomexe( path );
    char cmdline[ _POSIX_ARG_MAX ];
    int  retval;

    cmdline[ 0 ] = '\0';

    if( mode == P_NOWAIT ) {
        errno = EINVAL;

        return( -1 );
    }

    if( mode == P_SYSTEM ) __batflag = 1;

    if( fullpath == NULL ) {
        errno = ENOENT;

        return( -1 );
    }

    if( __batflag ) strcpy( cmdline, fullpath );

    if( *argv == NULL ) goto skip;
    argv++; /* We don't use argv[ 0 ] */

    for( ; *argv != NULL; argv++ ) {
        int white = 0;

        if( strrchr( *argv, ' ' ) != NULL ) white = 1;
        if( white ) strcat( cmdline, " \"" );
        strcat( cmdline, *argv );
        if( white ) strcat( cmdline, "\""  );
    }
skip:

    if( __batflag ) {
        system( cmdline );

        return( __errorlevel );
    }

    retval = _exece( fullpath, cmdline, envp );

    if( mode == P_OVERLAY ) exit( retval );

    return( retval );
}

