#include <spawn.h>
#include <process.h>
#include <unistd.h>
#include <errno.h>

int posix_spawn( pid_t * restrict pid, const char * restrict path,
                 const posix_spawn_file_actions_t *file_actions,
                 const posix_spawnattr_t * restrict attrp,
                 char * const argv[], char * const envp[] )
{
    if( spawnvpe( P_WAIT, ( char * )path,
                          ( char ** )argv,
                          ( char ** )envp ) == -1 ) {
        return( errno );
    }

    if( pid != NULL ) *pid = getpid() + 1; /* Get a different PID than ours */

    return( 0 );
}

