#include <malloc.h>
#include <errno.h>
#include <dos.h>

#ifdef __WATCOMC__
unsigned _SS( void );
#pragma aux _SS =   \
    "mov ax, ss"    \
    parm [ax];

extern unsigned _STACKTOP;
extern unsigned _curbrk;
extern unsigned _psp;

int brk( void *addr )
{
    unsigned *__curbrk = addr, curbrk = ( __curbrk ) ? *__curbrk : 0, seg_size;

    if( curbrk < _STACKTOP ) {
        errno = ENOMEM;
        return( -1 );
    }

    seg_size = ( ( curbrk + 0x0F ) >> 4 ) ? ( curbrk + 0x0F ) >> 4 : 0x1000;

    seg_size += _SS() - _psp;

    if( setblock( _psp, seg_size ) != -1 ) {
        errno = ENOMEM;
        return( -1 );
    }

    _curbrk = curbrk;

    return( 0 );
}
#endif

