#include <dos.h>
#include <io.h>
#include <errno.h>
#include <sys/stat.h>

int __dogtatr( const char *filename );
#pragma aux __dogtatr = \
    "mov ax, 0x4300"    \
    "int 0x21"          \
    "jc skip"           \
    "mov ax, cx"        \
    "skip:"             \
    "sbb ax, ax"        \
    parm [dx]           \
    value [ax]          \
    modify [ax dx cx];

int __dostatr( const char *filename, unsigned attrs );
#pragma aux __dostatr = \
    "mov ax, 0x4301"    \
    "int 0x21"          \
    "sbb ax, ax"        \
    parm [dx] [cx]      \
    value [ax]          \
    modify [ax dx cx];

int chmod( const char *filename, mode_t access )
{
    register int retval = __dogtatr( __retsfn( filename ) );

    if( retval < 0 ) {
        errno = ENOENT;
        return( -1 );
    }

    if( ( access & S_IREAD ) && !( access & S_IWRITE ) ) {
        retval |= _A_RDONLY;
    } else {
        retval &= ~_A_RDONLY;
    }

    if( __dostatr( __retsfn( filename ), retval ) < 0 ) {
        errno = EACCES;

        return( -1 );
    }

    return( 0 );
}

