#ifndef __STRING_H
#define __STRING_H

#include <_defs.h>
#include <stddef.h>

extern int ffs( int value );
extern char *_far2nearcpy( char *dest, const char far *source );
extern void *memccpy( void *dest, const void *source, int ch, size_t len );
extern void *memcpy( void *dest, const void *source, size_t len );
extern void *memmove( void *dest, const void *source, size_t len );
extern void *memchr( const void *dest, int ch, size_t len );
extern int memcmp( const void *m1, const void *m2, size_t len );
extern int memicmp( const void *m1, const void *m2, size_t len );
extern void *memrev( void *buf, size_t count );
extern void *memset( void *mem, int ch, size_t len );
extern void movedata( unsigned s, unsigned o, unsigned d, unsigned t, size_t l);
extern char far *_near2farcpy( char far *dest, const char *source );
extern char *strchr( const char *string, int ch );
extern char *strrchr( const char *string, int ch );
extern char *strstr( const char *string, const char *pattern );
extern char *stristr( const char *string, const char *pattern );
extern char *strrstr( const char *string, const char *pattern );
extern char *strristr( const char *string, const char *pattern );
extern char *strcat( char *dest, const char *source );
extern int strcmp( const char *s1, const char *s2 );
extern int strcmpi( const char *s1, const char *s2 );
extern int strcoll( const char *s1, const char *s2 );
extern size_t strlcat( char *dst, const char *src, size_t size );
extern size_t strlcpy( char *dst, const char *src, size_t size );
extern int strncmp( const char *s1, const char *s2, size_t len );
extern int strncmpi( const char *s1, const char *s2, size_t len );
extern char *strnset( char *string, int ch, size_t len );
extern char *strset( char *string, int ch );
extern char *strcpy( char *dest, const char *source );
extern char *strncpy( char *dest, const char *source, size_t len );
extern char *strpbrk( const char *string, const char *pattern );
extern size_t strlen( const char *string );
extern size_t strcspn( const char *s1, const char *s2 );
extern size_t strspn( const char *s1, const char *s2 );
extern char *strdup( const char *string );
extern char *strlwr( char *string );
extern char *strtok( char *delimited, const char *token );
extern char *strrev( char *string );
extern char *strncat( char *dest, const char *source, size_t len );
extern char *stpcpy( char *dest, const char *source );
extern void far *_fmemccpy( void far *d, const void far *s, int c, size_t l );
extern void far *_fmemcpy( void far *dest, const void far *source, size_t l );
extern void far *_fmemmove( void far *d, const void far *s, size_t len );
extern void far *_fmemchr( const void far *dest, int ch, size_t len );
extern int _fmemcmp( const void far *m1, const void far *m2, size_t len );
extern int _fmemicmp( const void far *m1, const void far *m2, size_t len );
extern void far *_fmemrev( void far *buf, size_t count );
extern void far *_fmemset( void far *mem, int ch, size_t len );
extern char far *_fstrchr( const char far *string, int ch );
extern char far *_fstrrchr( const char far *string, int ch );
extern char far *_fstrstr( const char far *string, const char far *pattern );
extern char far *_fstristr( const char far *string, const char far *pattern );
extern char far *_fstrrstr( const char far *string, const char far *pattern );
extern char far *_fstrristr( const char far *string, const char far *pattern );
extern char far *_fstrcat( char far *dest, const char far *source );
extern int _fstrcmp( const char far *s1, const char far *s2 );
extern int _fstrcmpi( const char far *s1, const char far *s2 );
extern int _fstrcoll( const char far *s1, const char far *s2 );
extern size_t _fstrlcat( char far *dst, const char far *src, size_t size );
extern size_t _fstrlcpy( char far *dst, const char far *src, size_t size );
extern int _fstrncmp( const char far *s1, const char far *s2, size_t len );
extern int _fstrncmpi( const char far *s1, const char far *s2, size_t len );
extern char far *_fstrnset( char far *string, int ch, size_t len );
extern char far *_fstrset( char far *string, int ch );
extern char far *_fstrcpy( char far *dest, const char far *source );
extern char far *_fstrncpy( char far *d, const char far *s, size_t len );
extern char far *_fstrpbrk( const char far *string, const char far *pattern );
extern size_t _fstrlen( const char far *string );
extern size_t _fstrcspn( const char far *s1, const char far *s2 );
extern size_t _fstrspn( const char far *s1, const char far *s2 );
extern char far *_fstrdup( const char far *string );
extern char far *_fstrlwr( char far *string );
extern char far *_fstrtok( char far *delimited, const char far *token );
extern char far *_fstrrev( char far *string );
extern char far *_fstrncat( char far *d, const char far *s, size_t len );
extern char far *_fstpcpy( char far *dest, const char far *source );

extern char *strerror( int errnum );
extern char *_strerror( const char *string );

#define bcmp                memcmp
#define bcopy( x, y, z )    memcpy( y, x, z )
#define bzero( x, y )       memset( x, '\0', y )
#define index               strchr
#define movmem( x, y, z )   memmove( y, x, z )
#define _fmovmem( x, y, z ) _fmemmove( y, x, z )
#define setmem( x, y, z )   memset( x, z, y )
#define _fsetmem( x, y, z ) _fmemset( x, z, y )
#define rindex              strrchr
#define strcasecmp          strcmpi
#define strncasecmp         strncmpi
#define _strlwr             strlwr
#define _strncnt( s1, len ) ( strlen( s1 ) > len ? len : strlen( s1 ) )
#define _strdec( s1, s2 )   ( ( char * )( ( s1 >= s2 ) ? ( s1 ) : ( --s2 ) ) )
#define _strdup             strdup
#define _strinc( s1 )       ( ( char * )( ++s1 ) )
#define _strninc( s1, cnt ) ( ( char * )( s1 += cnt ) )
#define _strnset            strnset
#define _strset             strset
#define _strrev             strrev
#define _strupr             strupr
#define strnicmp            strncmpi
#define stricmp             strcmpi
#define _stricmp            strcmpi
#define _strcmpi            strcmpi
#define strstri             stristr
#define strrstri            strristr
#define _fstrcasecmp        _fstrcmpi
#define _fstrncasecmp       _fstrncmpi
#define _fstrnicmp          _fstrncmpi
#define _fstricmp           _fstrcmpi
#define _fstrstri           _fstristr
#define _fstrrstri          _fstrristr

#endif

