#ifndef __STDIO_H
#define __STDIO_H

#include <sys/types.h>
#include <_printf.h>
#include <stdarg.h>

typedef long fpos_t;

typedef struct {
    int fd;
    unsigned flags;
    char unget;
    char *tempfnam;
} FILE;

extern int      __getomode( const char *mode );

extern char *   ctermid( char *s );
extern int      fclose( FILE *fp );
extern int      fcloseall( void );
extern FILE *   fdopen( int handle, const char *mode );
extern int      fgetc( FILE *fp );
extern int      fgetchar( void );
extern int      fgetpos( FILE *fp, fpos_t *pos );
extern char *   fgets( char *string, int num, FILE *fp );
extern int      _fnprintf( int( *fn )( int c ), const char *fmt, ... );
extern FILE *   fopen( const char *filename, const char *mode );
extern int      fprintf( FILE *fp, const char *fmt, ... );
extern int      fputc( int ch, FILE *fp );
extern int      fputchar( int ch );
extern int      fputs( const char *string, FILE *fp );
extern size_t   fread( void * restrict ptr, size_t ilen, size_t items,
                       FILE * restrict fp );
extern FILE *   freopen( const char * restrict filename,
                         const char * restrict mode, FILE * restrict fp );
extern int      fseek( FILE *fp, long offset, int loc );
extern int      fsetpos( FILE *fp, const fpos_t *pos );
extern FILE *   _fsopen( const char *filename, const char *mode, int shflag );
extern long     ftell( FILE *fp );
extern size_t   fwrite( const void * restrict ptr, size_t ilen, size_t items,
                        FILE * restrict fp );
extern char *   gets( char *string );
extern char *   gets_s( char *string, size_t len );
extern int      getw( FILE *fp );
extern void     perror( const char *string );
extern int      printf( const char *fmt, ... );
extern int      puts( const char *string );
extern int      putw( int ch, FILE *fp );
extern int      rename( const char *oldname, const char *newname );
extern void     rewind( FILE *fp );
extern int      rmtmp( void );
extern int      snprintf( char *string, int maxlen, const char *fmt, ... );
extern int      sprintf( char *string, const char *fmt, ... );
extern char *   tempnam( char *dir, char *prefix );
extern char *   tmpnam( char *s );
extern FILE *   tmpfile( void );
extern int      ungetc( int ch, FILE *stream );
extern int      unlink( const char *filename );
extern int      vasnprintf( char **string, int maxlen,
                            const char *fmt, va_list args );
extern int      vasprintf( char **string, const char *fmt, va_list args );
extern int      vfnprintf( FILE *fp, size_t maxlen,
                           const char *fmt, va_list args );
extern int      vfprintf( FILE *fp, const char *fmt, va_list args );
extern int      vprintf( const char *fmt, va_list args );
extern int      vsnprintf( char *string, int maxlen,
                           const char *fmt, va_list args );
extern int      vsprintf( char *string, const char *fmt, va_list args );

#define __FERROR        0x01
#define __FEOF          0x02
#define __FTEXT         0x04

extern FILE __stdin_stream,
            __stdout_stream,
            __stderr_stream,
            __stdaux_stream,
            __stdprn_stream;
#define stdin                   &__stdin_stream
#define stdout                  &__stdout_stream
#define stderr                  &__stdout_stream
#define stdaux                  &__stdaux_stream
#define stdprn                  &__stdprn_stream
#define STDIN_FILENO            0
#define STDOUT_FILENO           1
#define STDERR_FILENO           2
#define STDAUX_FILENO           3
#define STDPRN_FILENO           4
#define _bprintf                snprintf
#define clearerr( fp )          ( fp->flags = 0 )
#define ferror( fp )            ( fp->flags & __FERROR )
#define feof( fp )              ( fp->flags & __FEOF )
#define fflush( fp )            ( 0 )
#define fileno( fp )            ( fp->fd )
#define flushall( )             ( 1 )
#define fseeko( fp, x, y )      ( fseek( fp, x, y ) )
#define ftello( fp )            ( ftell( fp ) )
#define getc                    fgetc
#define getchar                 fgetchar
#define L_ctermid               4
#define L_tmpnam                80
#define putc                    fputc
#define putchar                 fputchar
#define P_tmpdir                "."
#ifndef remove
#define remove                  unlink
#endif
#define setbuf( a, b )
#define setvbuf( a, b, c, d )   ( 0 )
#define TMP_MAX                 ( 10000 )
#ifdef __CLIB_LFN__
#ifndef PATH_MAX
#define PATH_MAX                260
#endif
#ifndef NAME_MAX
#define NAME_MAX                255
#endif
#ifndef FILENAME_MAX
#define FILENAME_MAX            255
#endif
#else
#ifndef PATH_MAX
#define PATH_MAX                80
#endif
#ifndef NAME_MAX
#define NAME_MAX                13
#endif
#ifndef FILENAME_MAX
#define FILENAME_MAX            13
#endif
#endif
#define _vbprintf               vsnprintf
#define _vfnprintf              __vfnprintf

#endif

