#ifndef __STDDEF_H
#define __STDDEF_H

#include <_defs.h>

typedef unsigned        size_t;
typedef unsigned long   time_t;
typedef int             ptrdiff_t;
typedef int             wchar_t;

#ifdef __HAVE_LONG_LONG__
typedef struct {
    long long quot;
    long long rem;
} lldiv_t;
#endif

typedef struct {
    long quot;
    long rem;
} ldiv_t;

typedef struct {
    int quot;
    int rem;
} div_t;

#define NULL                    '\0'
#define offsetof( type, id )    ( ( size_t ) & ( ( ( type * ) 0 )->id ) )

#endif

