#ifndef __SIGNAL_H
#define __SIGNAL_H

typedef unsigned int sig_atomic_t;

extern void ( *__handlers[] )( int sig );

extern void    __sigdfl( int sig );
extern void    __sigerr( int sig );
extern void    __sigign( int sig );

extern int     raise( int sig );
extern void ( *signal( int sig, void ( *func )( int sig ) ) )( int sig );

#define SIG_DFL __sigdfl
#define SIG_ERR __sigerr
#define SIG_IGN __sigign

#define SIGINT  0
#define SIGABRT 1
#define SIGFPE  2
#define SIGILL  3
#define SIGSEGV 4
#define SIGTERM 5
#define SIGALRM 6

#endif

