#ifndef __SEARCH_H
#define __SEARCH_H

#include <_defs.h>
#include <stddef.h>

typedef struct entry {
    char *key;
    void *data;
} ENTRY;

typedef enum {
    FIND,
    ENTER
} ACTION;

typedef enum {
    preorder,
    postorder,
    endorder,
    leaf
} VISIT;

typedef struct __node {
    char *          key;
    struct __node  *llink, *rlink;
} __node_t;

extern void     insque( void *elem, void *pred );
extern void *   lfind( const void *k, const void *b, size_t *n, size_t width,
                       int ( *compar )( const void *m1, const void *m2 ) );
extern void *   lsearch( const void *key, void *base, size_t *n, size_t width,
                         int ( *compar )( const void *m1, const void *m2 ) );
extern void     remque( void *elem );
extern void *   tdelete( const void *vkey, void **vrootp,
                         int ( *c )( const void *m1, const void *m2 ) );
extern void *   tfind( const void *vkey, void **vrootp,
                       int ( *c )( const void *m1, const void *m2 ) );
extern void *   tsearch( const void *vkey, void **vrootp,
                         int ( *c )( const void *m1, const void *m2 ) );
extern void     twalk( const void *v,
                       void ( *a )( const void *m, VISIT x, int y ) );

#endif

