#ifndef __PROCESS_H
#define __PROCESS_H

#include <_defs.h>

extern unsigned _psp;

extern int      _bgetcmd( char *cmdline, int len );
extern int      execl( const char *path, ... );
extern int      execle( const char *path, ... );
extern int      execlp( const char *path, ... );
extern int      execlpe( const char *path, ... );
extern int      execv( const char *path, char **argv );
extern int      execve( const char *path, char **argv, char **envp );
extern int      execvp( const char *path, char **argv );
extern int      execvpe( const char *path, char **argv, char **envp );
extern char *   getcmd( char *cmdline );
extern unsigned getpsp( void );
extern int      spawnl( int mode, char *path, ... );
extern int      spawnle( int mode, char *path, ... );
extern int      spawnlp( int mode, char *path, ... );
extern int      spawnlpe( int mode, char *path, ... );
extern int      spawnv( int mode, const char *path, char **argv );
extern int      spawnve( int mode, const char *path, char **argv, char **envp );
extern int      spawnvp( int mode, const char *path, char **argv );
extern int      spawnvpe( int mode, const char *path, char **argv, char **env );
extern int      system( const char *cmdline );

#define getpid      getpsp
#define P_WAIT      0   /* Wait for the child to complete */
#define P_NOWAIT    1   /* Return immediately and run child in background */
#define P_OVERLAY   2   /* Replace the parent with the child */
#define P_SYSTEM    3   /* Run the child through the command interpreter */

#endif

