#ifndef __LIMITS_H
#define __LIMITS_H

#include <_defs.h>

#define CHAR_BIT                    8
#define SCHAR_MAX                   0x7F
#define SCHAR_MIN                   ( -SCHAR_MIN - 1 )
#define UCHAR_MAX                   0xFF
#ifdef __CHAR_SIGNED__
#define CHAR_MAX                    SCHAR_MAX
#define CHAR_MIN                    SCHAR_MIN
#else
#define CHAR_MAX                    UCHAR_MAX
#define CHAR_MIN                    0
#endif
#define WORD_BIT                    16
#define INT_MAX                     0x7FFF
#define INT_MIN                     ( -INT_MAX - 1 )
#define UINT_MAX                    0xFFFFU
#define SHRT_MAX                    INT_MAX
#define SHRT_MIN                    INT_MIN
#define USHRT_MAX                   UINT_MAX
#define SSIZE_MAX                   INT_MAX
#define LONG_BIT                    32
#define LONG_MAX                    0x7FFFFFFFL
#define LONG_MIN                    ( -LONG_MAX - 1L )
#define ULONG_MAX                   0xFFFFFFFFUL
#define LLONG_MAX                   0x7FFFFFFFFFFFFFFFLL
#define LLONG_MIN                   ( -LLONG_MAX - 1LL )
#define ULLONG_MAX                  0xFFFFFFFFFFFFFFFFULL

#define _POSIX_ARG_MAX              4096
#define _POSIX_CHILD_MAX            25
#define _POSIX_HOST_NAME_MAX        255
#define _POSIX_LINK_MAX             8
#define _POSIX_LOGIN_NAME_MAX       9
#define _POSIX_MAX_CANON            255
#define _POSIX_MAX_INPUT            255
#define _POSIX_NAME_MAX             14
#define _POSIX_NGROUPS_MAX          8
#define _POSIX_OPEN_MAX             20
#define _POSIX_PATH_MAX             256
#define _POSIX_PIPE_BUF             512
#define _POSIX_RE_DUP_MAX           255
#define _POSIX_SSIZE_MAX            INT_MAX
#define _POSIX_STREAM_MAX           8
#define _POSIX_SYMLINK_MAX          255
#define _POSIX_SYMLOOP_MAX          8
#define _POSIX_TTY_NAME_MAX         9
#define _POSIX_TZNAME_MAX           6
#define _POSIX2_BC_BASE_MAX         99
#define _POSIX2_BC_DIM_MAX          2048
#define _POSIX2_BC_SCALE_MAX        99
#define _POSIX2_BC_STRING_MAX       1000
#define _POSIX2_CHARCLASS_NAME_MAX  14
#define _POSIX2_COLL_WEIGHTS_MAX    2
#define _POSIX2_EXPR_NEST_MAX       32
#define _POSIX2_LINE_MAX            2048
#define _POSIX2_RE_DUP_MAX          255
#define _XOPEN_IOV_MAX              16
#define _XOPEN_NAME_MAX             255
#define _XOPEN_PATH_MAX             260

#define ARG_MAX                     _POSIX_ARG_MAX
#define ATEXIT_MAX                  32
#define CHILD_MAX                   _POSIX_CHILD_MAX
#define HOST_NAME_MAX               _POSIX_HOST_NAME_MAX
#define IOV_MAX                     INT_MAX
#define LOGIN_NAME_MAX              _POSIX_LOGIN_NAME_MAX
#define OPEN_MAX                    20
#define PAGESIZE                    16
#define PAGE_SIZE                   16
#define RE_DUP_MAX                  _POSIX2_RE_DUP_MAX
#define STREAM_MAX                  20
#define SYMLOOP_MAX                 _POSIX_SYMLOOP_MAX
#define SYMLINK_MAX                 512
#define TTY_NAME_MAX                _POSIX_TTY_NAME_MAX
#define TZNAME_MAX                  128

#define FILESIZEBITS                32
#define LINK_MAX                    _POSIX_LINK_MAX
#define MAX_CANON                   _POSIX_MAX_CANON
#define MAX_INPUT                   _POSIX_MAX_INPUT
#define NAME_MAX                    255
#define PATH_MAX                    260
#define PIPE_BUF                    _POSIX_PIPE_BUF

#define BC_BASE_MAX                 _POSIX2_BC_BASE_MAX
#define BC_DIM_MAX                  _POSIX2_BC_DIM_MAX
#define BC_SCALE_MAX                _POSIX2_BC_SCALE_MAX
#define BC_STRING_MAX               _POSIX2_BC_STRING_MAX
#define CHARCLASS_NAME_MAX          _POSIX2_CHARCLASS_NAME_MAX
#define COLL_WEIGHTS_MAX            _POSIX2_COLL_WEIGHTS_MAX
#define EXPR_NEST_MAX               _POSIX2_EXPR_NEST_MAX
#define LINE_MAX                    _POSIX2_LINE_MAX
#define NGROUPS_MAX                 _POSIX_NGROUPS_MAX

#define NL_ARGMAX                   INT_MAX
#define NL_LANGMAX                  260
#define NL_MSGMAX                   INT_MAX
#define NL_NMAX                     32
#define NL_SETMAX                   UCHAR_MAX
#define NL_TEXTMAX                  2048

#define NZERO                       20

#endif

