#ifndef __GETOPT_H
#define __GETOPT_H

struct option {
    char *name;                   /* the name of the long option */
    int has_arg;                  /* one of the above macros */
    int *flag;                    /* 
                                   * determines if getopt_long() returns a
                                   * value for a long option; if it is
                                   * non-NULL, 0 is returned as a function
                                   * value and the value of val is stored in
                                   * the area pointed to by flag.  Otherwise,
                                   * val is returned. */
    int val;                      /*
                                   * determines the value to return if flag is
                                   * NULL.
                                   */
};

extern int      optopt,
                optind,
                opterr;
extern char *   optarg;

extern int  getopt( int argc, char **argv, char *opts );
extern int  getopt_long( int argc, char **argv, char *shortopts,
                         struct option * longopts, int *longind );
extern int  getopt_long_only( int argc, char **argv, char *shortopts,
                              struct option * longopts, int *longind );

#endif

