#ifndef __FCNTL_H
#define __FCNTL_H

#include <_defs.h>
#include <io.h>
#include <unistd.h>
#include <sys/stat.h>

struct flock {
    short l_type;
    short l_whence;
    off_t l_start;
    off_t l_len;
    pid_t l_pid;
};

extern int _fmode;

extern int fcntl( int fildes, int cmd, ... );

#define F_DUPFD     0
#define F_GETFD     1
#define F_SETFD     2
#define F_GETFL     3
#define F_SETFL     4
#define F_GETLK     5
#define F_SETLK     6
#define F_SETLKW    7
#define F_GETOWN    8
#define F_SETOWN    9

#define FD_CLOEXEC  0x01

#define F_RDLCK     1
#define F_UNLCK     2
#define F_WRLCK     3

#define O_RDONLY    0x0000  /* Read-only */
#define O_WRONLY    0x0001  /* Write-only */
#define O_RDWR      0x0002  /* Read-write */
#define O_APPEND    0x0004  /* Set position to the end of the file */
#define O_CREAT     0x0008  /* Create a new file */
#define O_TRUNC     0x0800  /* Truncate an existing file */
#define O_NOINHERIT 0x0080  /* Close on EXEC */
#define O_TEXT      0x0100  /* Operate in text mode */
#define O_BINARY    0x0200  /* Operate in binary mode */
#define O_EXCL      0x0400  /* O_EXECL + O_CREAT = Fail if file exists */
#define O_DENYALL   0x0010  /* Deny reads/writes by other handles */
#define O_DENYWRITE 0x0020  /* Deny writes by other handles */
#define O_DENYREAD  0x0030  /* Deny reads by other handles */
#define O_DENYNONE  0x0040  /* Deny nothing to other handles */
#define O_NOCTTY    0x2000  /* Don't make the handle the controlling terminal */
#define O_DSYNC     0x4000  /* Flush after writes */
#define O_RSYNC     0x8000  /* Flush after reads */
#define O_SYNC      0x4000  /* Flush after file operations */

#define O_ACCMODE   0x07FF

#endif

