#include <dos.h>
#include <string.h>

/*
 * Borland/Watcom-alike intr function.  Use "void *" because a program
 * designed for Watcom would use "union REGPACK" and a program designed
 * for the Borland family of compilers would use "struct REGPACK".
 * Also, programs designed for this CLIB can also use "union _INTREGS" or
 * "union _INTR" (some compilers only).
 */
int int86x( int intno, union REGS *inregs,
                       union REGS *outregs, struct SREGS *segs )
{
    union _INTR r;

    memcpy( &r, inregs, sizeof( union REGS ) );
    memcpy( &r + 18, segs, sizeof( struct SREGS ) );
    r.flags = inregs->x.flags;
    _callint( intno, &r, &r );
    memcpy( outregs, &r, sizeof( union REGS ) );
    memcpy( segs, &r + 18, sizeof( struct SREGS ) );
    outregs->x.flags = r.flags;
    outregs->x.cflag = r.cflag;

    return( r.ax );
}

