#include <dos.h>
#include <errno.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>

/*
 * fflushall() isn't necessary before calling child because FILE streams are
 * always unbuffered
 * This function is a clone of the function of the same name in DeSmet C and
 * is provided as a more direct interface to the AH=4Bh call to call a child
 * process.
 */

struct __execblock {
    unsigned short  envseg;
    void far *      cmdtail;
    void far *      fcb1;
    void far *      fcb2;
};

int __dodexec( const char *path, struct __execblock far *xb );
#pragma aux __dodexec = \
    "mov ax, 0x4B00"    \
    "int 0x21"          \
    "jnc finish"        \
    "mov _doserrno, ax" \
    "mov ax, 0xFFFF"    \
    "finish:"           \
    parm [dx] [es bx]      \
    value [ax]          \
    modify [ax bx dx];

unsigned char __dogetrt( void );
#pragma aux __dogetrt = \
    "mov ah, 0x4D"      \
    "int 0x21"          \
    value [al]          \
    modify [ax];

static char __setcmdline[] = "CMDLINE=";

int _exec( const char *path, const char *cmdline )
{
    char cmdlinebuf[ _POSIX_ARG_MAX + 8 ], *fullcmdline = cmdlinebuf + 7;
    char far *envp;
    int i, j;
    unsigned seg, size = 0;
    struct __execblock xb = { 0, NULL, NULL, NULL };

    fullcmdline[ 0 ] = strlen( cmdline );
    fullcmdline[ fullcmdline[ 0 ] ] = '\r';
    strncpy( &fullcmdline[ 1 ], cmdline, _POSIX_ARG_MAX - 1 );

    if( strlen( cmdline ) > 126 ) { /* Support for CMDLINE var */
        strncpy( cmdlinebuf, __setcmdline, 7 );
        cmdlinebuf[ 7 ] = '=';
        putenv( cmdlinebuf );

        fullcmdline[ 0 ] = 126;
        fullcmdline[ 127 ] = '\r';
    }

    for( i = 0; environ[ i ] != NULL; i++ ) {
        size += strlen( environ[ i ] ) + 1;
    }
    size += 2;

    if( _dos_allocmem( ( size / 16 ) + 1, &seg ) ) {
        putenv( __setcmdline );

        return( -1 );
    }
    envp = MK_FP( seg, 0 );
    xb.envseg = seg;

    for( i = 0; environ[ i ] != NULL; i++ ) {
        for( j = 0; environ[ i ][ j ] != '\0'; j++ ) {
            *envp = environ[ i ][ j ];
            envp++;
        }
        *envp = '\0';
        envp++;
    }
    *envp = '\0';
    xb.cmdtail = ( char far * )fullcmdline;

    if( __dodexec( path, &xb ) < 0 ) {
        putenv( __setcmdline );
        _dos_freemem( xb.envseg );

        return( -1 );
    }

    putenv( __setcmdline );

    _dos_freemem( xb.envseg );

    return( __dogetrt() );
}

