#include <dos.h>

#define INIT		6		/* initial clock set	*/

void delay( unsigned mill )
{
    static long count = 0;
    long loops;
    struct dostime_t n1, n2;
    int delay;
  
    if( count == 0 ) { /* wait for a clock tick */
        count = 1000L;
        _dos_gettime( &n1 );
        delay = n1.hsecond;
        while( n1.hsecond == delay ) _dos_gettime( &n1 );

        /* first get a ballpark figure */
        for( loops = count; loops--; loops = ( loops << 1 ) / 2 );
        _dos_gettime( &n2 );
        delay = ( 100 * n2.second + n2.hsecond ) -
                ( 100 * n1.second + n1.hsecond );
        if ( delay < 0 ) delay += 6000;

        /* this is the first guess */
        count = 100 * count / delay;

        /* this one should be about 2 sec */
        _dos_gettime( &n1 );
        for( loops = INIT * count; loops--; loops = ( loops << 1 ) / 2 );
        _dos_gettime( &n2 );
        delay = ( 100 * n2.second + n2.hsecond ) -
                ( 100 * n1.second + n1.hsecond );
        if( delay < 0 ) delay += 6000;
        count = INIT * 100 * count / delay;
    }

    for( loops = mill * count / 1000; loops--; loops = ( loops << 1 ) / 2 );
}

