#include <libgen.h>
#include <string.h>
#include <direct.h>

int fnsplit( const char *path,
                   char *drive,
                   char *dir,
                   char *name,
                   char *ext )
{
    char *dname = dirname( path );
    char *bname = basename( path );
    int retval = 0;

    if( dname != NULL && strcmp( dname, "." ) != 0 ) {
        if( dname[ 1 ] == ':' ) {
            if( drive ) strncpy( drive, dname, 2 );
            retval |= DRIVE;

            dname += 2;
        }
        if( *dname ) {
            if( dir ) strcpy( dir, dname );
            retval |= DIRECTORY;
        }
    }
    if( bname != NULL && strcmp( bname, "." ) != 0 ) {
        char *b = bname;

        while( *b && *b != '.' ) b++;

        if( *b == '.' ) {
            if( ext ) strcpy( ext, b );
            retval |= EXTENSION;

            *b = '\0';
        }
        if( *bname ) {
            if( name ) strcpy( name, bname );
            retval |= FILENAME;
        }
    }

    if( strchr( path, '*' ) != NULL || strchr( path, '?' ) != NULL )
        retval |= WILDCARDS;

    if( retval & FILENAME || retval & EXTENSION ) strcat( dir, "\\" );

    return( retval );
}

