#include <dos.h>
#include <errno.h>

#ifdef __CLIB_LFN__
int __dolfnfn( unsigned intr,
               unsigned handle,
               unsigned char attrs,
               const char *filename,
               void far *strptr );
#pragma aux __dolfnfn = \
    "mov si, 1"         \
    "stc"               \
    "int 0x21"          \
    "jnc finish"        \
    "sbb ax, ax"        \
    "finish:"           \
    parm [ax] [bx] [cl] [dx] [es di]\
    value [ax]          \
    modify [ax cx dx si di];

int __dolfncl( unsigned handle );
#pragma aux __dolfncl = \
    "mov ax, 0x71A1"    \
    "stc"               \
    "int 0x21"          \
    "sbb ax, ax"        \
    parm [bx]           \
    value [ax]          \
    modify [ax bx];
#endif

int __dofindf( unsigned char intr, int attrs, const char *filename );
#pragma aux __dofindf = \
    "int 0x21"          \
    "sbb ax, ax"        \
    parm [ah] [cx] [dx] \
    value [ax]          \
    modify [ax cx dx];

#ifdef __CLIB_LFN__
#define findfirst __sfn_findfirst
#define findnext __sfn_findnext
#endif

int findfirst( const char *filename, void *strptr, int attrib )
{
    register int retval;

    setdta( strptr );
    if( ( retval = __dofindf( 0x4E, attrib, filename ) ) < 0 ) {
        errno = ENOENT;
        return( -1 );
    }

    return( 0 );
}

int findnext( void *strptr )
{
    register int retval;

    setdta( strptr );
    if( ( retval = __dofindf( 0x4F, 0, NULL ) ) < 0 ) {
        errno = ENOENT;
        return( -1 );
    }

    return( 0 );
}

#ifdef __CLIB_LFN__
#undef findfirst
#undef findnext
#undef findclose

int findfirst( const char *filename, void *strptr, int attr )
{
    register int retval;
    struct __lfnfind temp;
    struct find_t *fblk = ( struct find_t * )strptr;

    fblk->lfnhandle = 0xFFFF;

    if( ( retval = __dolfnfn( 0x714E, fblk->lfnhandle,
                   ( unsigned char )attr,
                   filename,
                   &temp ) ) < 0 || retval == -0x7100 ) {
        return( __sfn_findfirst( filename, fblk, attr ) );
    }

    fblk->lfnhandle = retval;
    __convert_to_find( fblk, &temp );

    return( 0 );
}

int findnext( void *strptr )
{
    register int retval, i;
    struct find_t *fblk = strptr;
    struct __lfnfind temp;

    if( fblk->lfnhandle == 0xFFFF ) return( __sfn_findnext( strptr ) );

    if( ( retval = __dolfnfn( 0x714F, fblk->lfnhandle, 0, NULL, &temp ) ) < 0 )
    {
        errno = ENOENT;
        return( -1 );
    }

    __convert_to_find( fblk, &temp );

    return( 0 );
}

int findclose( void *strptr )
{
    register int retval;
    struct find_t *fblk = strptr;

    if( ( retval = __dolfncl( fblk->lfnhandle ) ) < 0 ) {
        errno = ENOENT;
        return( -1 );
    }

    return( 0 );
}

#endif

