#include <conio.h>
#include "globals.h"

unsigned __chcurchattr( unsigned char page,
                        unsigned char ch,
                        unsigned char attr );
#pragma aux __chcurchattr = \
    "mov ah, 0x09"          \
    "mov cx, 1"             \
    "mov dx, 0"             \
    "int 0x10"              \
    parm [bh] [al] [bl]     \
    modify [ax bx cx dx];

static void __vid_memwrite( void *ptr, int row, int col, int cnt )
{
    unsigned short *bufptr = ptr;
    unsigned char *xbufptr = ptr;
    unsigned short offset = ( 2 * __width * row ) + ( col * 2 );
    int curx = wherex(), cury = wherey();

    while( cnt-- ) {
        if( directvideo ) {
            __cgaenablevid( CGA_DISABLE );
            poke( __baseadr, offset, *bufptr++ );
            __cgaenablevid( CGA_ENABLE );
            offset += 2;
        } else {
            __gotoxy( row, col );
            col++;
            if( col >= __width ) {
                col = 0;
                row++;
            }
            __chcurchattr( __cur_page, *xbufptr++, *xbufptr++ );
        }
    }
    gotoxy( curx, cury );
}

int puttext( int left, int top, int right, int bottom, void *dest )
{
    int width = right - left + 1, size = width * 2;
    char *p = dest;
    register int i;

    left--;
    top--;
    right--;
    bottom--;

    if( !__conio_initialized ) __initialize_conio();

    if( left < 0 || top < 0 || right > __width || bottom > __length )
        return( 0 );

    for( i = top; i <= bottom; i++ ) {
        __vid_memwrite( p, i, left, width );
        p += size;
    }

    return( 1 );
}
