#include <conio.h>
#include "globals.h"

unsigned __getcurchattr( unsigned char page );
#pragma aux __getcurchattr =\
    "mov ah, 0x08"          \
    "int 0x10"              \
    parm [bh]               \
    value [ax]              \
    modify [ax bx];

static void __vid_memread( void *ptr, int row, int col, int cnt )
{
    unsigned short *bufptr = ptr;
    unsigned short offset = ( 2 * __width * row ) + ( col * 2 );
    int curx = wherex(), cury = wherey();

    while( cnt-- ) {
        if( directvideo ) {
            __cgaenablevid( CGA_DISABLE );
            *bufptr++ = peek( __baseadr, offset );
            __cgaenablevid( CGA_ENABLE );
            offset += 2;
        } else {
            __gotoxy( row, col );
            col++;
            if( col >= __width ) {
                col = 0;
                row++;
            }
            *bufptr++ = __getcurchattr( __cur_page );
        }
    }
    gotoxy( curx, cury );
}

int gettext( int left, int top, int right, int bottom, void *dest )
{
    int width = right - left + 1, size = width * 2;
    char *p = dest;
    register int i;

    left--;
    top--;
    right--;
    bottom--;

    if( !__conio_initialized ) __initialize_conio();

    if( left < 0 || top < 0 || right > __width || bottom > __length )
        return( 0 );

    for( i = top; i <= bottom; i++ ) {
        __vid_memread( p, i, left, width );
        p += size;
    }

    return( 1 );
}
