#include <conio.h>
#include "globals.h"

void __dosetcr( unsigned type );
#pragma aux __dosetcr = \
    "mov ah, 0x01"      \
    "int 0x10"          \
    parm [cx]           \
    modify [ax cx];

void _setcursortype( unsigned type )
{
    switch( type ) {
        case _SOLIDCURSOR:
            __dosetcr( ( __cur_mode == 7 ) ? 0x010C : 0x0107 );
            break;
        case _NORMALCURSOR:
            __dosetcr( ( __cur_mode == 7 ) ? 0x0B0C : 0x0607 );
            break;
        case _NOCURSOR:
            __dosetcr( 0x2020 );
            break;
        case _HALFCURSOR:
            __dosetcr( ( __cur_mode == 7 ) ? 0x070C : 0x0407 );
            break;
    }
}
