/*
 * $Id: ctmath.c,v 1.1 2004/08/25 17:03:00 lf_sfnet Exp $
 */

/*
 * Harbour Project source code:
 *   initialization and switch functions for CT3 math functions
 *
 * Copyright 2001 IntTec GmbH, Neunlindenstr 32, 79106 Freiburg, Germany
 *        Author: Martin Vogel <vogel@inttec.de>
 *
 * www - http://www.harbour-project.org
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307 USA (or visit the web site http://www.gnu.org/).
 *
 * As a special exception, the Harbour Project gives permission for
 * additional uses of the text contained in its release of Harbour.
 *
 * The exception is that, if you link the Harbour libraries with other
 * files to produce an executable, this does not by itself cause the
 * resulting executable to be covered by the GNU General Public License.
 * Your use of that executable is in no way restricted on account of
 * linking the Harbour library code into it.
 *
 * This exception does not however invalidate any other reasons why
 * the executable file might be covered by the GNU General Public License.
 *
 * This exception applies only to the code released by the Harbour
 * Project under the name Harbour.  If you copy code from other
 * Harbour Project or Free Software Foundation releases into a copy of
 * Harbour, as the General Public License permits, the exception does
 * not apply to the code that you add in this way.  To avoid misleading
 * anyone as to the status of such modified files, you must delete
 * this exception notice from them.
 *
 * If you write modifications of your own for Harbour, it is your choice
 * whether to permit this exception to apply to your modifications.
 * If you do not wish that, delete this exception notice.
 *
 */


#include "ct.h"

/* ---------------- */
/*  initialization  */
/* ---------------- */
int ct_math_init()
{
  HB_TRACE(HB_TR_DEBUG, ("ct_math_init()"));
  return (1);
}

int ct_math_exit()
{
  HB_TRACE(HB_TR_DEBUG, ("ct_math_exit()"));
  return (1);
}

/* ---------------- */
/*  math precision  */
/* ---------------- */
static int s_ct_precision = 16;  /* TODO: make this thread safe */

void ct_setprecision (int iPrecision)
{
  HB_TRACE(HB_TR_DEBUG, ("ct_setprecision (%i)", iPrecision));
  s_ct_precision = iPrecision;
  return;
}
int ct_getprecision (void)
{
  HB_TRACE(HB_TR_DEBUG, ("ct_getprecision()"));
  return (s_ct_precision);
}



HB_FUNC (SETPREC)
{

  if ((ISNUM (1)) &&
      (hb_parni (1) >= 1) &&
      (hb_parni (1) <= 16))
  {
    ct_setprecision (hb_parni (1));
  }
  else
  {
    int iArgErrorMode = ct_getargerrormode();
    if (iArgErrorMode != CT_ARGERR_IGNORE)
    {
      ct_error ((USHORT)iArgErrorMode, EG_ARG, CT_ERROR_SETPREC,
                NULL, "SETPREC", 0, EF_CANDEFAULT, 1, hb_paramError (1));
    }
  }

  hb_retc ("");

}



HB_FUNC (GETPREC)
{

  hb_retni (ct_getprecision ());
  if (hb_pcount() > 0)
  {
    int iArgErrorMode = ct_getargerrormode();
    if (iArgErrorMode != CT_ARGERR_IGNORE)
    {
      ct_error ((USHORT)iArgErrorMode, EG_ARG, CT_ERROR_GETPREC,
                NULL, "GETPREC", 0, EF_CANDEFAULT, 1, hb_paramError (1));
    }
  }

}
