\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : An alternative for DIR 
\ CATEGORY    : Turnkey programs 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -stdlib


:noname
        cr ." LS [filespec]"
        cr ."    -b   backups: {??"
        cr ."    -d   only directories"
        cr ."    -e   executables: COM, EXE and BAT"
        cr ."    -f   Forth files: FRT"
        cr ."    -n   normal files, no directories"
        ;  is .help

: .lower
        out #16 + c/l >
        if      cr
        then
        out
        if      #16 out over mod - spaces
        then
        found-attribute $10 and
        if      '-'
        else    bl
        then
        emit 0
        ?do     count dup 'A' [ 'Z' 1+ ] literal within
                if      bl or
                then
                emit
        loop
        drop
        ;

: prepare
        file-1 @ c@
        if      file-1 @ count '.' scan nip 0=
                if      s" .*" file-1 @ append
                then
                file-1 @ 1+ c@ '.' =
                if      file-1 @ count s" *" temporary pack append
                        temporary count file-1 @ place
                then
                file-1 @ count + 1- c@ '.' =
                if      s" *" file-1 @ count temporary pack append
                        temporary count file-1 @ place
                then
        else    drop s" *.*" file-1 @ place
        then
        ;

: one-file
        'b' option
        if      drop found-file '{' scan nip
                if      found-file .lower
                then
                exit
        then
        'd' option
        if      drop found-attribute $10 =
                if      found-file .lower
                then
                exit
        then
        'e' option
        if      drop found-file dup 3 - /string
                2dup s" EXE" compare 0= >r
                2dup s" COM" compare 0= >r
                s" BAT" compare 0= r> r> or or
                if      found-file .lower
                then
                exit
        then
        'f' option
        if      drop found-file dup 3 - /string
                s" FRT" compare 0=
                if      found-file .lower
                then
                exit
        then
        'n' option
        if      drop found-attribute $10 <>
                if      found-file .lower
                then
                exit
        then
        argc @ 0=
        if      found-file .lower exit
        then
        .help bye
        ;

: cat
        ms-dos-io $10 to find-attribute prepare file-1 @ count
        find-first-file throw
        begin   found-file s" ." compare
                if      found-file s" .." compare
                        if      one-file
                        then
                then
                find-next-file
        until
        ;  ' cat is proc

signon off

statoff

turnkey main ls
                            \ (* End of Source *) /
