\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Clock with big digits 
\ CATEGORY    : Turnkey programs 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -screensv

false [if]

: tick
       10 time 2drop 1+ 6 lshift tone
        ;

[else]

: tick
        ;

[then]

: newcrlf
        #16 0
        do      ^M (emit) ^J (emit)
        loop
        ;

: bigemit
        ^M of   newcrlf exit    then
        ^J of   exit    then
        dup ^L =
        if      (emit) exit
        then
        ?at 16 < swap 8 + c/l > or
        if      newcrlf
        then
        #255 and dup #128 <
        if      $FFA6 $0E
        else    #128 - $1F get-interrupt
        then
        rot 3 lshift + ?at #15 - local y local x #16 0
        do      x y i + at-xy countx dup 8 0
                do      2* split
                        if      #219
                        else    bl
                        then
                        (emit)
                loop
                drop x y 1+ i + at-xy 8 0
                do      2* split
                        if      #219
                        else    bl
                        then
                        (emit)
                loop
                drop
        2 +loop
        2drop
        ;

: large
        ['] bigemit is emit
        ;

: small
        ['] (emit) is emit
        ;

: kleur
        begin   #15 choose 7 choose 2dup =
        while   2drop
        repeat
        4 lshift or attr ! page
        ;

: .type.
        0
        ?do     count emit
        loop
        drop
        ;

: klokje
        hide-cursor large
        begin   time 2drop
                begin   dup time 2drop <>
                until
                drop $80 c@
                if      kleur
                then
                0 4 at-xy space (time) .type.
                tick
                [ internal ] getkey [ forth ]
        until
        small show-cursor
        ;

create at' 4 allot

: main
        save-screen ?at at' 2!
        page klokje
        restore-screen at' 2@ at-xy
        ;

turnkey main big
                            \ (* End of Source *) /
