\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : A small decompiler for CHForth 
\ CATEGORY    : Debugging 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : July 05, 1994, Coos Haak, also colon definitions
\ LAST CHANGE : 10 Mar 94, Coos Haak, Fully reworked 
\ LAST CHANGE : 04 dec 93, Coos Haak, English version
\ LAST CHANGE : 26 nov 93, Coos Haak, ANSI version van CHForth 
\ CREATED     : 02 nov 93, Coos Haak 
\ ----------------------------------------------------------------------



        MARKER -view



DOC
        A little decompiler, load it with:
                NEEDS -view
        Its size is only 2,5 Kb, instead of the DECOMPILER of 4,3 Kb
        and the DISASSEMBLER of 11,8 Kb.

        VIEW <word>
        VIEW <addr>
        <addr> (VIEW)
ENDDOC

\G When this value is true, inline strings are displayed as with
\G DUMP using VIEW .
FALSE VALUE STRINGS?    ( -- x )                    \ VIEW

internal also

privates

: .literal              ( x -- )
        false of    ."  False" exit then
        true of     ."   True" exit then
        dup $-80 $7F within
        if      dup 0 bl within
                if      4 spaces '^' emit $40 or emit
                else    dup 0>
                        if      3 spaces ''' emit emit ''' emit
                        else    6 .r
                        then
                then
        else    6 u.r
        then
        ;  private

0 value there   private

?def class [if]

: .class
        there >body @ 2 cells - space .vocname
        ;  private

[then]

: jumptype
        there >call case
        [ find-methods docon 2 cells + ] literal of ." CONSTANT" 2  endof
        [ find-methods dovar 2 cells + ] literal of ." VARIABLE" 2  endof
        [ find-methods dovoc 2 cells + ] literal of ." VOCABULARY" 4    endof
        [ find-methods doseg 2 cells + ] literal of ." SEGMENT" 2   endof
        [ find-methods dovector 2 cells + ] literal of  ." VECTOR" 2     endof
        [ find-methods docreate 2 cells + ] literal of  ." CREATE" 2    endof
        [ find-methods doval 2 cells + ] literal of     ." VALUE" 2     endof
        [ ' : >call ] literal of    ." :" 3 endof
        [ find-methods do2var 2 cells + ] literal of    ." 2VARIABLE" 2 endof
        [ find-methods do2con 2 cells + ] literal of    ." 2CONSTANT" 2 endof
        [ find-methods prefix 2 cells + ] literal of    ." PREFIX" 2 endof
        [ find-methods domarker 2 cells + ] literal of  ." MARKER" #vocs 4 + endof
[ ?def revision ] [if]
        [ find-methods revision 2 cells + ] literal
                of ." REVISION" there >body 2 cells + c@ 1+ #cells
                #vocs 6 + + endof
[then]
        [ find-methods drive 2 cells + ] literal of ." DRIVE" 2  endof
        [ find-methods dos: 2 cells + ] literal of  ." DOS:" 2   endof
[ ?def dvalue ] [if]
        [ find-methods dodval 2 cells + ] literal of    ." DVALUE" 2 endof
[then]
[ ?def class ] [if]
        [ find-methods class 2 cells + ] literal of ." CLASS" 3 endof
        [ find-methods var 2 cells + ] literal of   ." VAR" 2   endof
        [ find-methods def> 2 cells + ] literal of  ." DEF>" .class 3   endof
        [ find-methods var> 2 cells + ] literal of  ." VAR>" .class 3   endof
        [ find-methods array.var> 2 cells + ] literal of    ." ARRAY.VAR>" .class 3 endof
        [ find-methods array.def> 2 cells + ] literal of    ." ARRAY.DEF>" .class 3 endof
[then]
[ ?def floats ] [if]
        [ find-methods fconstant 2 cells + ] literal of ." FCONSTANT" 2 endof
        [ find-methods fvalue 2 cells + ] literal of    ." FVALUE" 2    endof
[then]
[ ?def intvec ] [if]
        [ find-methods dointvec 2 cells + ] literal of  ." INTVEC" 2    endof
[then]
        there c@ $E9 =
        if      ." Jump "
        else    ." Call "
        then
        there >call h. 2 swap
        endcase
        ;  private

0 value xhere   private

: inline-code-string
        '"' emit space xhere cell+ l@ count tuck 2dup type '"' emit
        strings?
        if      -1 /string dump
        else    2drop
        then
        1+ aligned +to there
        1 cells +to xhere
        ;  private

: inline-list-string
        '"' emit space xhere cell+ typestring '"' emit
        strings?
        if      lseg xhere cell+ countx -1 /string dumpx
        then
        xhere cell+ l@ $FF and 1+ aligned +to xhere
        ;  private

: inline-number
        #30 htab
        xhere cell+ l@ dup .hex .literal 1 cells +to xhere
        ;  private

: inline-address
        #36 htab
        1 cells +to xhere
        lseg xhere l@ x.
        ;  private

: inline-name
        1 cells +to xhere xhere l@ body> >head .head
        ;  private

: inline-local
        push base decimal
        1 cells +to xhere ." LOCAL " xhere l@ 2/ .
        pop base
        ;  private

: .colon
        to xhere
        begin   cr #12 spaces lseg xhere x. space xhere l@ h. space
                case xhere l@
                ['] (postpone) of ." POSTPONE " xhere cell+ l@ >head .head
                        1 cells +to xhere endof
                ['] (.") of '.' emit inline-list-string      endof
                ['] (c") of 'C' emit inline-code-string      endof
                ['] (s") of 'S' emit inline-code-string      endof
                ['] (abort") of ." ABORT" inline-code-string      endof
                ['] (if) of ." IF " inline-address endof
                ['] (else) of ." ELSE " inline-address endof
                ['] (while) of ." WHILE " inline-address endof
                ['] (until) of ." UNTIL " inline-address endof
                ['] (again) of ." AGAIN " inline-address endof
                ['] (repeat) of ." REPEAT " inline-address endof
                ['] (of) of ." OF " inline-address endof
                ['] (endof) of ." ENDOF " inline-address endof
                ['] (do) of ." DO " inline-address endof
                ['] (?do) of ." ?DO " inline-address endof
                ['] (ahead) of ." AHEAD " inline-address endof
                ['] (loop) of ." LOOP" endof
                ['] (+loop) of ." +LOOP" endof
                ['] (then) of ." THEN" endof
                ['] (case) of ." CASE" endof
                ['] (endcase) of ." ENDCASE" endof
                ['] (begin) of ." BEGIN" endof
                ['] (lit) of space xhere cell+ l@ dup .hex .literal
                        1 cells +to xhere endof
                ['] (chr) of xhere cell+ l@ dup bl <
                        if      '^' emit $40 or emit
                        else    ''' emit emit ''' emit
                        then
                        1 cells +to xhere endof
                ['] (tic) of ." ['] " xhere cell+ l@ >head .head
                        1 cells +to xhere endof
                ['] modify of ." DOES> " xhere cell+ l@ 2 cells +
                        #36 htab cseg swap x.
                        exit endof
                ['] (exit) of ." ;" exit endof
                ['] (val) of ." FROM " inline-name endof
                ['] (to) of ." TO " inline-name endof
                ['] (+to) of ." +TO " inline-name endof
                ['] (clear) of ." CLEAR " inline-name endof
                ['] (adr) of ." ADR " inline-name endof
                ['] (get) of ." GET " inline-name endof
                ['] (push) of ." PUSH " inline-name endof
                ['] (pop) of ." POP " inline-name endof
                ['] (is) of ." IS " inline-name endof
                ['] (loc) of inline-local endof
                ['] (toloc) of ." TO " inline-local endof
                ['] (+toloc) of ." +TO " inline-local endof
                ['] (clearloc) of ." CLEAR " inline-local endof
                dup >head ?dup
                if      dup head>flags h@ =immediate and
                        if      ." POSTPONE "
                        then
                        .head
                else    ."  ??? " 4 spaces ''' emit
                        xhere l@ split swap semit semit
                        ''' emit
                then
                endcase
                1 cells +to xhere
                key ^[ =
        until
        r>drop                  \ Throw return address away to stop
    ;  private

\G Display data starting from addr.
: (VIEW)                ( addr -- )                     \ VIEW
        to there
        begin   cr cseg there x.
                there c@ dup $E9 = swap $E8 = or there 3 + c@ $FC = and
                if      there >call [ ' quit >call ] literal =
                        if      ." :" there >head ?dup
                                if      space .head
                                then
                                there >body @ .colon
                                3
                        else    there >call
                                [ find-methods dovoc 2 cells + >call ]
                                literal =
                                if      ." DOES>" there >body @ .colon
                                        3
                                else    jumptype there >head ?dup
                                        if      space .head
                                        then
                                then
                        then
                else    space space there @ dup h. .literal 6 spaces
                        ''' emit there count semit c@ semit ''' emit
                        there >head ?dup
                        if      #36 htab there h. .head space
                        then
                        there char+ >head ?dup
                        if      #50 htab there char+ h. .head
                        then
                        1
                then
                cells +to there
                there here = key ^[ = or
        until
        ;

\G Find "name" in the search-order or convert it to an address.
\G Display one line at the time of data with, space continues,
\G other keys terminate.
: VIEW          ( "name" -- )                           \ VIEW
        bl word find
        if      (view) exit
        then
        count number? 1 <> $FFF3 ?error (view)
        ;

deprive

previous forth

                            \ (* End of Source *) /
