\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Implementation of REVISION for CHForth 1.2.1
\ CATEGORY    : Compatibilities
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : July 29, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        MARKER -revision



?undef revision [if]

internal also definitions

0 value revisions                               \ links all REVISIONs

: f:revision
    @+ to revisions                             \ unlink
    @+ release-context                          \ restore context information
    cr ." Removing " count type                 \ type message
    ;

forth definitions

: revision      ( "name" "<">ccc<">" -- )
    >in @ bl word find
    if      execute
    else    drop
    then
    >in !
    create  here revisions , to revisions       \ link
            here 0 ,                            \ mark
            '"' parse 2drop                     \ skip including leading quote
            cr ." Creating "
            here ", count type                  \ type message
            here swap !                         \ resolve
            mark-context                        \ save context information
    does>   body> (forget)                      \ forget itself
    ;

' f:revision is-forget revision

: .revisions
    depth >r revisions
    begin   ?dup
    while   dup @
    repeat
    depth r>
    ?do     cr dup body> >head .head            \ type the name
            #24 htab 2 cells + count type       \ and the message
    loop
    ;

:noname
    .revisions [ editor ] restore-line [ forth ]
    ;  $4300 []key !                            \ F9

also decompiler definitions

: .rv
        ." REVISION " >parm 2 cells + count type
        ;
' .rv ' revision >body 3 cells + tab!

previous previous forth definitions

[then]

DOC
revision -first     " My first  revision  Version 1.00 "
revision -second    " My second revision  Version 1.00 "
revision -third     " My third  revision  Version 1.00 "
revision -fourth    " My fourth revision  Version 1.00 "
ENDDOC

                            \ (* End of Source *) /
