\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Double locals 
\ CATEGORY    : Extensions 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : February 23, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -assembler


        MARKER -dlocals


INTERNAL DEFINITIONS ALSO

CASESENSITIVE ON

PRIVATES

CODE dloc@
                LODSW   ES:
                MOV     DI, ' LSP! 2 + @
                ADD     DI, AX
                PUSH    BX
                PUSH    SS: 0 [DI]
                MOV     BX, SS: -2 [DI]
                NEXT
END-CODE  COMPILE-ONLY  PRIVATE

CODE dloc!
                LODSW   ES:
                MOV     DI, ' LSP! 2 + @
                ADD     DI, AX
                POP     SS: 0 [DI]
                MOV     SS: -2 [DI], BX
                POP     BX
                NEXT
END-CODE  COMPILE-ONLY  PRIVATE

CODE dloc+!
                LODSW   ES:
                MOV     DI, ' LSP! 2 + @
                ADD     DI, AX
                POP     AX
                ADD     SS: 0 [DI], AX
                ADC     SS: -2 [DI], BX
                POP     BX
                NEXT
END-CODE  COMPILE-ONLY  PRIVATE

CODE dloc0!
                LODSW   ES:
                MOV     DI, ' LSP! 2 + @
                ADD     DI, AX
                XOR     AX, AX
                MOV     SS: 0 [DI], AX
                MOV     SS: -2 [DI], AX
                NEXT
END-CODE  COMPILE-ONLY  PRIVATE

ALIGN
CODE DLocRet
                ADD     ' LSP! 2 + @ # 2 CELLS
                XCHG    SP, BP
                POP     SI
                XCHG    SP, BP
                NEXT
END-CODE  PRIVATE

' DLocRet L,

CODE PUSH-DLOCAL
                XCHG    SP, BP
$IF386
                PUSH    # LHERE CELL-
$ELSE
                MOV     AX, # LHERE CELL-
                PUSH    AX
$THEN
                XCHG    SP, BP
                POP     AX
                XCHG    SP, ' LSP! 2 + @
                PUSH    AX
                PUSH    BX
                XCHG    SP, ' LSP! 2 + @
                POP     BX
                NEXT
END-CODE  COMPILE-ONLY

DOER: DODLOCAL
        POSTPONE dloc@ >LOCAL L,
        ;

METHODS DODLOCAL

: TO
        POSTPONE dloc! >LOCAL L,
        ;

: +TO
        POSTPONE dloc+! >LOCAL L,
        ;

: CLEAR
        POSTPONE dloc0! >LOCAL L,
        ;

END-METHODS

: (DLOCAL)          ( c-addr u -- )
        [ ' DODLOCAL >BODY 3 CELLS + ] LITERAL
        ((LOCAL)) 2 +TO LOCALS POSTPONE PUSH-DLOCAL
    ;  COMPILE-ONLY

?DEF -DECOMPILER [IF]

ALSO DECOMPILER

:NONAME
        CELL+ L@+ \" DLOCAL " 2/ 1- .
        ;  ' dloc@ TAB!

:NONAME
        CELL+ L@+ \" TO DLOCAL " 2/ 1- .
        ;  ' dloc! TAB!

:NONAME
        CELL+ L@+ \" +TO DLOCAL " 2/ 1- .
        ;  ' dloc+! TAB!

:NONAME
        CELL+ L@+ \" CLEAR DLOCAL " 2/ 1- .
        ;  ' dloc0! TAB!

PREVIOUS

[THEN]

FORTH DEFINITIONS

\G Create a dictionary entry with name "name" and initial value d.
\G
\G Executing:
\G ( -- d )
\G Place the value on the stack. The value can be manipulated by
\G TO +TO and CLEAR .
: DLOCAL                ( d "name" -- )                    \ DLOCALS
        BL PARSE-WORD (DLOCAL)
        ;  IMMEDIATE  COMPILE-ONLY

: DLOCALS|
        BEGIN   BL PARSE-WORD S" |" COMPARE
        WHILE   PARSED-WORD (DLOCAL)
        REPEAT
        ;  IMMEDIATE  COMPILE-ONLY

DEPRIVE

CASESENSITIVE OFF

PREVIOUS FORTH DEFINITIONS

                            \ (* End of Source *) /
