\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : XLISP functions in Forth 
\ CATEGORY    : Programming 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : March 01, 1994, Coos Haak 
\ ----------------------------------------------------------------------


        MARKER -xlisp


DOC
   XLISP is a form of LISP with objects.
   It is much more easy to write the program in Forth
ENDDOC

privates

prefix display
prefix up
prefix down
prefix left
prefix right
prefix goto
prefix char

: turtle        ( -- )
        create  0 , 0 , bl c,
        does>   abort" Can't execute a turtle directly"
        ;

: (display      ( adr -- )
        local adres
        adres 2@ at-xy adres 2 cells + c@ emit
        ;  private

: (blank        ( adr -- )
        local adres
        adres 2@ at-xy '' emit
        ;  private

: (up
        local adres
        adres (blank
        adres dup @ 1- 0 max swap !
        adres (display
        ;  private

: (down
        local adres
        adres (blank
        adres dup @ 1+ l/scr 1- min swap !
        adres (display
        ;  private

: (left
        local adres
        adres (blank
        adres cell+ dup @ 1- 0 max swap !
        adres (display
        ;  private

: (right
        local adres
        adres (blank
        adres cell+ dup @ 1+ c/l 2 - min swap !
        adres (display
        ;  private

methods turtle

: display       ( -- )
        postpone literal postpone (display
        ;

: goto          ( x y -- )
        postpone literal postpone 2!
        ;

: up            ( -- )
        postpone literal postpone (up
        ;

: down          ( -- )
        postpone literal postpone (down
        ;

: left          ( -- )
        postpone literal postpone (left
        ;

: right         ( -- )
        postpone literal postpone (right
        ;

: char          ( c -- )
        2 cells + postpone literal postpone c!
        ;

end-methods

deprive

DOC
/* An example in C++ or something like it */
main() {
        turtle x;
        x::char('');
        x::goto(cperl / 2, lpers / 2);
        curoff();
        do {
                switch (choose(4)) {
                        0:      x::up();        break;
                        1:      x::down();      break;
                        2:      x::left();      break;
                        default:        x::right();
                }
                delay(10);
        } while (!keypressed())
        curon();
        home();
}
ENDDOC

turtle x

: go
        c/l 2/ l/scr 2/ goto x '' char x
        hide-cursor
        begin   4 choose
                case
                        0 of    up x    endof
                        1 of    down x  endof
                        2 of    left x  endof
                        right x
                endcase
                10 ms
                key?
        until
        key drop show-cursor home
        ;


                            \ (* End of Source *) /
