\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Weird control structure
\ CATEGORY    : Evaluating new programming tools
\ AUTHOR      : Jack Brien, FIGUK #78
\ LAST CHANGE : August 30, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        ?DEF -weirdo [IF] -weirdo [THEN]


        MARKER -weirdo


DOC

CHForth uses two numbers instead of three in iForth on the
compilation (data) stack, indicated with 'sys', while building
control structures. In this program they are saved in a variable
called cs. These number of numbers is therefore very dependant on
the type of Forth you use and therefore is poorly portable.

A structure BEGIN AGAIN is used here with interleaving IF THEN .
Some Forth compilers, like iForth may use REPEAT after BEGIN
without a WHILE . Alas, not in CHForth!

ENDDOC

privates

create cs   0 , 0 ,                     private     \ Keep control numbers

: >:        ( sys -- )                              \ Forward label
        cs 2!
    ;  immediate  compile-only

: <:        ( -- sys )                              \ Use label
        cs 2@
    ;  immediate  compile-only

: return    ( -- )                                  \ Special leave
        postpone exit                               \ Leave definition
        postpone then                               \ Terminate structure
    ;  immediate  compile-only

-- Examples ...

: a     'a' emit ;
: b     'b' emit ;
: c     'c' emit ;
: d     'd' emit ;
: e     'E' emit ;

: a?    cr ."  'a' to stop "  key 'a' = ;
: b?    cr ."  'b' restarts " key 'b' = ;
: c?    cr ."  'c' does 'd?', else 'e?' " key 'c' = ;
: d?    cr ."  'd' restarts " key 'd' = ;
: e?    cr ."  not 'e' restarts " key 'e' = ;

-- Type WEIRDO and try to get out without 
-- using the Vulcan Nerve Pinch :-)
: WEIRDO
        CR ." I'll tell you three times ..." 
        4 1 DO 
                BEGIN >:
                   a? IF a UNLOOP RETURN
                   b? IF b <: AGAIN THEN            \ iForth may use REPEAT
                   c? IF 
                         d? IF d <: AGAIN THEN
                    ELSE c e? <: UNTIL
                    THEN 
                   cr I .dec 2 spaces  e            \ iForth has DEC.
          LOOP ;

:NONAME ( -- )  
        BEGIN >:  r> . ; drop

-- Try:   52 start  ( prints 52 .. I hope)
: START ( n -- )
        >r <: AGAIN ;


deprive


                            \ (* End of Source *) /
