\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Programs from the book The Next Step
\ CATEGORY    : Browsing Forth Sources
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : September 07, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        ?DEF -nextstep [IF] -nextstep [THEN]


        MARKER -nextstep


s" IFORTH" environment? [IF] drop

: stop?
        s" wait?" evaluate
    ;  immediate

: ?leave
        s" if leave then" evaluate
    ;  immediate

[THEN]

: carray
        create  allot
        does>   +
    ;

\ 200 constant size                              \ Maximally 120!, 200 digits
16000 constant size
size carray storage                             \ Store digits in here
variable lastdigit                              \ Remember last digit

: *n        ( x -- )                            \ New number in storage
        0                                       \ carry
        lastdigit @ 1+ 0
        do      over i storage c@ * +           \ multiply
                10 /mod swap i storage c!       \ store new digit
        loop
        begin   ?dup                            \ was there a carry?
        while   10 /mod swap                    \ get carry on top
                1 lastdigit +!                  \ use one digit more
                lastdigit @ dup 1+ size >       \ overflow ?
                abort" Overflow"                \ then say so!
                storage c!                      \ store digit there
        repeat
        drop
    ;

: setup     ( -- )                              \ initialize calculation
        1 0 storage c!                          \ 0!=1
        lastdigit off                           \ no carry
    ;

: .fact     ( -- )                              \ display array
        lastdigit @ 1+ 0
        do      lastdigit @ i - dup 1+ 3 mod 0= \ print comma per thousand
                i 0<> and                       \ and not the first digit
                if      ',' emit                \ the comma
                then
                storage c@ 1 .r
        loop
    ;

: fact      ( x -- )                            \ calculate x!
        setup 1+ 1
        do      i *n
        loop
    ;

: n.facts   ( x -- )                            \ print all x! upto x
        setup 1+ 1
        do      i *n
                cr i 3 .r ." != "
                200 ms .fact
        loop
    ;

: .times
        1001 100
        do      cr i 5 .r ." ! in " timer-reset i fact .ms
                stop? ?leave
        100 +loop
    ;


                            \ (* End of Source *) /
