\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Postfix control stucture
\ CATEGORY    : Evaluating new programming tools
\ AUTHOR      : Gordon Charlton
\ LAST CHANGE : August 27, 1994, Coos Haak
\ LAST CHANGE : August 27, 1994, Marcel Hendrix
\ CREATED     : August 26, 1994, Gordon Charlton
\ ----------------------------------------------------------------------



        NEEDS -stack


        ?DEF -control [IF] -control [THEN]


        MARKER -control


DOC

(*
  About {: ;} {COND} {IFELSE} {WHILE}

  You can do these very easily with a control flow stack.
  Main disadvantages of Gordon's code: 
   - deliberately obscure :-)
   - can't use {: ;} parts that leave something on the data stack.
 
 Assume the availability of an extra S-stack: >S  S> -S  S T
 Assume :NONAME can execute while compiling.
*)

ENDDOC

DOC

In CHForth you could not use :NONAME pairs because some security
is done with !CSP and ?CSP and I don't have the 'puf' to change
all that.  Also ; can not be used because it sets interpret state
and you cannot compile the rest of the definition.

ENDDOC

INTERNAL CLEAR CHARFLAG FORTH       \ Only for SEE and VIEW: LITERAL in {:

: {: ( C: -- sys1 sys2 )
        POSTPONE AHEAD                              \ Compile forward branch
        HERE                                        \ Keep xt
        [ ' QUIT >CALL ] LITERAL JUMP,              \ Compile docol
        LHERE ,                                     \ Compile pointer to LSEG
    ;  IMMEDIATE  COMPILE-ONLY

: ;} ( C: sys1 sys2 -- ) ( S: executing; -- xt )
        POSTPONE EXIT                               \ End subdefinition
        >R                                          \ Keep xt on returnstack
        POSTPONE THEN                               \ Resolve branch
        R> POSTPONE LITERAL                         \ Compile xt as a literal
        POSTPONE >S                                 \ Put it on s-stack later
    ;  IMMEDIATE  COMPILE-ONLY

: {IFELSE}  ( S: xt xt xt)  
        S> S> 2>R                                   \ Move top two xt's
        S> EXECUTE                                  \ Execute the first
        IF      R> R>                               \ Place third on top
        ELSE    2R>                                 \ Place second on top
        THEN
        DROP                                        \ Throw that one away
        EXECUTE                                     \ Execute the right one
    ;  COMPILE-ONLY

: {WHILE} ( S: xt xt)  
        BEGIN   T EXECUTE                           \ Execute conditional xt
        WHILE   S EXECUTE                           \ Execute unconditional xt
        REPEAT
        -S -S                                       \ Discard xt's
    ;  COMPILE-ONLY

: {COND} ( S: xt -- )
        S>                              \ Last xt
        $DEADBEEF >S                    \ Put marker on s-stack
        0 >S                            \ and false flag
        EXECUTE                         \ Put all xt's on the s-stack
        BEGIN   S> S> EXECUTE 0=        \ Get right part and execute left part
        WHILE   DROP                    \ Drop right part
        REPEAT
        EXECUTE                         \ The right part
        BEGIN   -S S> $DEADBEEF =       \ Discard s-stack pairs
        UNTIL
    ;  COMPILE-ONLY

\ USAGE;
: TESTIFELSE
        {: KEY BL = ;} 
              {: ." spacebar " ;}
              {: ." some other key " ;}  
        {IFELSE} ;

\ is equivalent to 
\ : TT1   KEY BL = IF ." spacebar" ELSE ." some other key " THEN ;

\ USAGE; 
: TESTWHILE    
        {: CR ." press spacebar.." KEY BL <> ;}
        {: ." I said 'spacebar'" ;}
     {WHILE} ;

\ is equivalent to 
\ : TT2 BEGIN  CR ." press spacebar.." KEY BL <> 
\       WHILE  ." I said 'spacebar'"  
\       REPEAT ;

\ {: {: test1 ( --f) ;}  {: action1 ;}
\    {: test2 ( --f) ;}  {: action2 ;} 
\    {: test3 ( --f) ;}  {: action3 ;} 
\    {: test4 ( --f) ;}  {: action4 ;} 
\    {: TRUE ;}    {: defaultaction ;}  ;}  
\
\ Like COND in LISP {COND} evaluates each test clause
\ until one is true and then performs the associated action. If the
\ default action is do-nothing then it is possible to omit
\ {: TRUE ;} {: defaultaction ;}
\ In this implementation the tests are executed in reverse order.

: TESTCOND
  {: {: TRUE ;}  {: ."  You earned a cookie" ;}  
     {: CR ." press D.." KEY 'D' <> ;} {: ." I said 'D'" ;}
     {: CR ." press C.." KEY 'C' <> ;} {: ." I said 'C'" ;}
     {: CR ." press B.." KEY 'B' <> ;} {: ." I said 'B'" ;}
     {: CR ." press A.." KEY 'A' <> ;} {: ." I said 'A'" ;}  ;} 
  {COND} ;

                            \ (* End of Source *) /
