\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Bitmanipulation
\ CATEGORY    : Utilities
\ AUTHOR      : Marcel Hendrix
\ LAST CHANGE : September 03, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -bits


        ?DEF -bitmanip [IF] -bitmanip [THEN]


        MARKER -bitmanip


DOC

Leuk voor mensen die van menuutjes houden, of als two-liner
voor het Vijgeblad?

-- Use like CASE 3 OF .. ENDOF  IN[ 7 19 ]OF .. ENDOF ENDCASE
--  n DUP DUP x y 1+ WITHIN 0= + OF .. 
--    ( true  ) n n  0 + OF -> n n   OF
--    ( false ) n n -1 + OF -> n n-1 OF 

: IN[
        S" DUP DUP " EVALUATE
    ;  IMMEDIATE  COMPILE-ONLY

: ]OF
        S" 1+ WITHIN 0= + OF " EVALUATE
    ;  IMMEDIATE  COMPILE-ONLY

-- Example
: IQ    CASE KEY 
              'A'    OF ." Bingo!"  ENDOF
        IN[ 'B' 'K' ]OF ." B .. K " ENDOF
        IN[ 'b' 'k' ]OF ." b .. k " ENDOF
              'Z'    OF ." close."  ENDOF
                        DUP EMIT ." ? "
        ENDCASE ;

ENDDOC

DOC

Hier de ultieme case statement. De code komt uit mijn in
de steigers staande PL/1 compiler, en is vanwege de daar van belang
zijn de snelheid in CODE (32-bits). 

De bedoeling is de al getoonde IN[ ]OF ENDOF uit te breiden zodat je
tussen de haken een willekeurige lijst met selectoren mag plaatsen.
Bovendien moet het niet nodig zijn een aaneensluitende reeks 
selectoren ieder apart te selecteren, dus 'A' 'B' 'C' moet ook als
'A' 'C' thru  kunnen.

Alle letters van het alfabet, de getallen, en het teken '_'
af te vangen volstaat de notatie:

  SETOF[ 'A' 'Z' thru  'a' 'z' thru '0' '9' thru '_' ]SETOF

Met een kleine wijziging kan je deze sets ook gebruiken samen
met IF , UNTIL en WHILE , niet alleen met OF ENDOF .
Ik heb de sets geimplementeerd met 8 32 bits in-line woorden,
-otaal 256 bits, net zoals in Pascal en Modula II. Meer kan,
maar gaat ruimte vreten.

Wie maakt een SET pakketje met + - * (vereniging, verschil, 
overlapping), en een paar in-line en definierende woorden?

- marcel

ENDDOC

DOC

Ik heb de namen veranderd naar de bestaande in CHForth.

  Marcel    Coos

  bit?      testbit
  bset      setbit
  breset    clearbit
  -bit?     in-set?
  >bit<     changebit
  dec.      .dec

                Coos.

ENDDOC

        PRIVATES

CODE IN-SET?            ( char addr -- char char' )
$IF386
                POP     AX
                PUSH    AX
                BT      0 [BX], AX                      \ char in set?
        U>= IF
                DEC     AX              \ no, make char and char' different
        THEN
                MOV     BX, AX
$ELSE
                POP     DI
                PUSH    DI
                MOV     CX, DI
                AND     CL, # 7
                MOV     AL, # 1
                ROL     AL, CL
                MOV     CL, # 3
                SAR     DI, CL
                AND     AL, 0 [BX+DI]
                POP     DI
                PUSH    DI
        0= IF
                DEC     DI
        THEN
                MOV     BX, DI
$THEN
                NEXT
END-CODE  PRIVATE

-- Extended case statement

-1 constant ]OF

0 VALUE set  private
0 VALUE prev private
0 VALUE now  private

: SHIFT         ( n -- )
        now TO prev  TO now 
    ;  private

: THRU          ( addr -- now )
        now prev < abort" .. arguments reversed"
        now 1+ prev
        ?DO     i $FF and set setbit
        LOOP
        now
    ;

: (SET[)        ( addr -- )
        TO set
        STATE OFF
        BEGIN   BL PARSE-WORD ?dup 
        WHILE   evaluate dup shift dup ]OF <>
        WHILE   $FF and  set setbit 
        REPEAT
        THEN
        drop
        STATE ON
    ;  private

: SET[
        here dup 32 chars dup allot erase       \ create an array of 256 bits
        DUP
        [ INTERNAL ] CHARFLAG OFF [ FORTH ]     \ for decompiler & disassembler
        POSTPONE LITERAL (SET[)
        POSTPONE in-set?
        POSTPONE OF
    ;  immediate  compile-only

        DEPRIVE

-- Tests

cr .( Do you need test routines [Y,n]) key dup emit cr >upc
'N' <> [IF]

: test  
        CASE 
                                        7 OF ." the `7'"    ENDOF 
             SET[ 1 9  'A' 'Z' thru  255 ]OF ." in the set" ENDOF 
        ENDCASE
    ;

CREATE bits[8] 0 c, 

: .BITS         ( -- )
        0 7
        DO      i bits[8] testbit
                IF      '1'
                ELSE    '0'
                THEN
                EMIT 
        -1 +LOOP
    ; 

: BINARY        ( -- )                          \ set base to 2
        2 BASE !
    ;

: TESTBIT?      ( -- )
        base @ >r binary
        cr $100 choose dup u. bits[8] c! ." --> %" .bits
        r> base !
    ;

: TESTBSET      ( -- )
        base @ >r binary
        cr ." bits[8] now : " bits[8] c@ u.
        cr 8 choose dup .dec bits[8] setbit ." --> %" .bits
        r> base !
    ;

: TEST>BIT<     ( -- )
        base @ >r binary
        cr ." bits[8] now : " bits[8] c@ u.
        cr 8 choose dup .dec bits[8] changebit ." --> %" .bits
        r> base !
    ;


: IQ
        CASE KEY 
              'A'    OF ." Bingo!"  ENDOF
        SET[ 'B' 'K' THRU ]OF ." B .. K " ENDOF
        SET[ 'b' 'k' THRU ]OF ." b .. k " ENDOF
              'Z'    OF ." close."  ENDOF
                        DUP EMIT ." ? "
        ENDCASE
    ;

[THEN]

                            \ (* End of Source *) /
