\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's
\ DESCRIPTION : The Famous Sieve of Eratosthanes
\ CATEGORY    : Benchmarks
\ AUTHOR      : Marcel Hendrix
\ LAST CHANGE : September 19, 1994, Coos Haak: Turnkey program
\ LAST CHANGE : May 16, 1994, Coos Haak
\ LAST CHANGE : October 5th, 1991 MHX
\ ----------------------------------------------------------------------



INTERNAL ALSO FORTH

HERE  LIMIT  #5000 - DP  !
LHERE LLIMIT #5000 - LDP !
        NEEDS -assembler
LDP !
DP !

PREVIOUS FORTH

        MARKER -sieveasm



#1000 CONSTANT #times
#8192 CONSTANT size

0 VALUE flags

CODE DO-PRIME
                push    bx
                push    si
                push    es
                push    cs
                pop     es
                mov     di, adr flags
                mov     cx, # SIZE
                mov     al, # 1
                rep     stosb
                mov     cx, # SIZE
                xor     di, di
                xor     dx, dx
                mov     bx, adr flags
        do
                test    0 [bx+di], # 1 byte
        0<> if
                mov     ax, di
                add     ax, ax
                add     ax, # 3
                mov     si, ax
                add     si, di
        begin
                cmp     si, # SIZE
        < while
                mov     0 [bx+si], # 0 byte
                add     si, ax
        repeat
                inc     dx
        then
                inc     di
        loop
                mov     bx, dx
                pop     es
                pop     si
                next    end-code


: PRIMES
                MS-DOS-IO HERE size ALLOT TO flags
                CR #times .DEC ." iterations."  TIMER-RESET
                0 #times 0 DO
                             DROP  DO-PRIME
                         LOOP
                CR .  ." primes found."
                GETTIME TIMESAVE 2@ D-
                #1000 #times M*/ <# # # # '.' HOLD #S #>
                CR TYPE ."  milliseconds per iteration. "
        ;

size RESERVE

TURNKEY PRIMES SIEVEASM

                            \ (* End of Source *) /
